<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\AcademicYearController;
use App\Http\Controllers\Admin\SchoolClassController;
use App\Http\Controllers\Admin\SectionController;
use App\Http\Controllers\Admin\BatchController;
use App\Http\Controllers\Admin\StudentController;
use App\Http\Controllers\Admin\TeacherController;
use App\Http\Controllers\Admin\SubjectController;
use App\Http\Controllers\Admin\ParentController as AdminParentController;
use App\Http\Controllers\Admin\TimetableController;
use App\Http\Controllers\Admin\RoomController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\NoteController;
use App\Http\Controllers\Admin\LeaveTypeController;
use App\Http\Controllers\Admin\LeaveRequestController as AdminLeaveRequestController;
use App\Http\Controllers\Admin\ExamTypeController;
use App\Http\Controllers\Admin\ExamScheduleController;
use App\Http\Controllers\ParentDashboardController;
use App\Http\Controllers\ParentPaymentController;
use App\Http\Controllers\ParentLeaveRequestController;
use App\Http\Controllers\ParentExamController;
use App\Http\Controllers\ParentAttendanceController;
use App\Http\Controllers\ParentHomeworkController;
use App\Http\Controllers\TeacherDashboardController;
use App\Http\Controllers\TeacherAttendanceController;
use App\Http\Controllers\Admin\StudentAttendanceController;
use App\Http\Controllers\TeacherLeaveRequestController;
use App\Http\Controllers\TeacherProfileController;
use App\Http\Controllers\TeacherExamController;
use App\Http\Controllers\Admin\NotificationController;

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
// Friendly alias URL for parents
Route::get('/parent/login', [LoginController::class, 'showLoginForm'])->name('parent.login');
// Friendly alias URL for teachers
Route::get('/teacher/login', [LoginController::class, 'showLoginForm'])->name('teacher.login');
Route::post('/login', [LoginController::class, 'login']);
// Allow both POST (forms) and GET (direct link) for logout to avoid 405 errors
Route::match(['get','post'], '/logout', [LoginController::class, 'logout'])->name('logout');

// Parent routes
Route::middleware(['auth'])->prefix('parent')->name('parent.')->group(function () {
    Route::get('/dashboard', [ParentDashboardController::class, 'index'])->name('dashboard');
    Route::get('/fees', [ParentDashboardController::class, 'fees'])->name('fees');
    Route::get('/timetable', [ParentDashboardController::class, 'timetable'])->name('timetable');
    Route::get('/students/{student}', [ParentDashboardController::class, 'student'])->name('students.show');
    Route::post('/fees/{collection}/pay', [ParentPaymentController::class, 'start'])->name('fees.pay');
    Route::get('/fees/{collection}/receipt', [ParentPaymentController::class, 'receipt'])->name('fees.receipt');
    Route::get('/leave-requests', [ParentLeaveRequestController::class, 'index'])->name('leave-requests.index');
    Route::get('/leave-requests/create', [ParentLeaveRequestController::class, 'create'])->name('leave-requests.create');
    Route::post('/leave-requests', [ParentLeaveRequestController::class, 'store'])->name('leave-requests.store');
    Route::get('/exams', [ParentExamController::class, 'index'])->name('exams.index');
    Route::get('/attendance', [ParentAttendanceController::class, 'index'])->name('attendance.index');
    Route::get('/homework', [ParentHomeworkController::class, 'index'])->name('homework.index');
    Route::get('/homework/{id}', [ParentHomeworkController::class, 'show'])->name('homework.show');
    Route::post('/homework/{homeworkId}/submit', [\App\Http\Controllers\ParentHomeworkSubmissionController::class, 'store'])->name('homework.submit');
    
    // Parent Notifications
    Route::get('/notifications', [\App\Http\Controllers\ParentNotificationController::class, 'index'])->name('notifications.index');
    Route::match(['get', 'post'], '/notifications/{id}/read', [\App\Http\Controllers\ParentNotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::post('/notifications/mark-all-read', [\App\Http\Controllers\ParentNotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');
    Route::delete('/notifications/{id}', [\App\Http\Controllers\ParentNotificationController::class, 'destroy'])->name('notifications.destroy');
});

// Teacher routes
Route::middleware(['auth'])->prefix('teacher')->name('teacher.')->group(function () {
    Route::get('/dashboard', [TeacherDashboardController::class, 'index'])->name('dashboard');
    Route::get('/attendance', [TeacherAttendanceController::class, 'index'])->name('attendance.index');
    Route::post('/attendance', [TeacherAttendanceController::class, 'store'])->name('attendance.store');
    Route::get('/timetable', [TeacherDashboardController::class, 'timetable'])->name('timetable');
    Route::get('/leave-requests', [TeacherLeaveRequestController::class, 'index'])->name('leave-requests.index');
    Route::get('/leave-requests/create', [TeacherLeaveRequestController::class, 'create'])->name('leave-requests.create');
    Route::post('/leave-requests', [TeacherLeaveRequestController::class, 'store'])->name('leave-requests.store');
    Route::get('/profile', [TeacherProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile', [TeacherProfileController::class, 'update'])->name('profile.update');
    Route::get('/exams/schedules', [TeacherExamController::class, 'index'])->name('exams.schedules.index');
    Route::get('/exams/schedules/create', [TeacherExamController::class, 'create'])->name('exams.schedules.create');
    Route::post('/exams/schedules', [TeacherExamController::class, 'store'])->name('exams.schedules.store');
    Route::get('/exams/schedules/{examSchedule}/marks', [TeacherExamController::class, 'marks'])->name('exams.schedules.marks');
    Route::post('/exams/schedules/{examSchedule}/marks', [TeacherExamController::class, 'storeMarks'])->name('exams.schedules.marks.store');
    Route::resource('homework', \App\Http\Controllers\Teacher\HomeworkController::class);
    Route::get('homework/{id}/students', [\App\Http\Controllers\Teacher\HomeworkController::class, 'getStudents'])->name('homework.students');
    Route::post('homework/{id}/mark-submissions', [\App\Http\Controllers\Teacher\HomeworkController::class, 'markSubmissions'])->name('homework.mark-submissions');
    
    // Teacher Notifications
    Route::get('notifications', [\App\Http\Controllers\TeacherNotificationController::class, 'index'])->name('notifications.index');
    Route::match(['get', 'post'], 'notifications/{id}/read', [\App\Http\Controllers\TeacherNotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::post('notifications/mark-all-read', [\App\Http\Controllers\TeacherNotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');
    Route::delete('notifications/{id}', [\App\Http\Controllers\TeacherNotificationController::class, 'destroy'])->name('notifications.destroy');
});

// Admin Routes
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Profile Routes
    Route::get('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'index'])->name('profile.index');
    Route::put('/profile', [\App\Http\Controllers\Admin\ProfileController::class, 'update'])->name('profile.update');
    Route::put('/profile/password', [\App\Http\Controllers\Admin\ProfileController::class, 'updatePassword'])->name('profile.password');
    
    // Academic Year Routes
    Route::resource('academic-year', AcademicYearController::class);
    
    // Class Routes
    Route::resource('class', SchoolClassController::class);
    
    // Subject Routes
    Route::resource('subject', SubjectController::class);
    
    // Section Routes
    Route::resource('section', SectionController::class);
    
    // Batch Routes
    Route::resource('batch', BatchController::class);
    
    // Student Routes (Admission)
    // Custom routes must be defined before resource routes to avoid conflicts
    Route::get('student/search-parents', [StudentController::class, 'searchParents'])->name('student.search-parents');
    Route::resource('student', StudentController::class);
    
    // Teacher Routes
    Route::resource('teacher', TeacherController::class);
    Route::delete('teacher/{teacher}/document/{document}', [TeacherController::class, 'deleteDocument'])->name('teacher.document.delete');
    
    // Parent Routes
    Route::resource('parent', AdminParentController::class);
    
    // Timetable Routes
    Route::resource('timetable', TimetableController::class)->only(['index','create','store','edit','update','destroy']);
    Route::resource('timetable-override', \App\Http\Controllers\Admin\TimetableOverrideController::class)->only(['index','create','store','edit','update','destroy']);

    // Fees Routes
    Route::resource('fees-type', \App\Http\Controllers\Admin\FeesTypeController::class)->only(['index','create','store','edit','update','destroy']);
    Route::resource('fees-group', \App\Http\Controllers\Admin\FeesGroupController::class)->only(['index','create','store','edit','update','destroy']);
    Route::resource('fees-discount', \App\Http\Controllers\Admin\FeesDiscountController::class)->only(['index','create','store','edit','update','destroy']);
    // Custom routes must be defined before resource routes to avoid conflicts
    Route::get('fees-collection/search-students', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'searchStudents'])->name('fees-collection.search-students');
    Route::resource('fees-collection', \App\Http\Controllers\Admin\FeesCollectionController::class)->only(['index','create','store','show','edit','update','destroy']);
    Route::post('fees-collection/{id}/add-payment', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'addPayment'])->name('fees-collection.add-payment');
    Route::delete('fees-collection/{collectionId}/payment/{paymentId}', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'deletePayment'])->name('fees-collection.delete-payment');
    Route::get('fees-collection/{collectionId}/payment/{paymentId}/print', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'printPayment'])->name('fees-collection.print-payment');
    Route::get('fees-collection/{id}/print-all-payments', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'printAllPayments'])->name('fees-collection.print-all-payments');
    Route::get('fees-collection/{id}/print-complete', [\App\Http\Controllers\Admin\FeesCollectionController::class, 'printComplete'])->name('fees-collection.print-complete');
    Route::resource('fees-assignment', \App\Http\Controllers\Admin\FeesAssignmentController::class)->only(['index','create','store','destroy']);
    Route::resource('timetable-override', \App\Http\Controllers\Admin\TimetableOverrideController::class)->only(['index','create','store','edit','update','destroy']);
    Route::resource('homework', \App\Http\Controllers\Admin\HomeworkController::class);
    Route::get('homework/{id}/students', [\App\Http\Controllers\Admin\HomeworkController::class, 'getStudents'])->name('homework.students');
    Route::post('homework/{id}/mark-submissions', [\App\Http\Controllers\Admin\HomeworkController::class, 'markSubmissions'])->name('homework.mark-submissions');
    Route::get('attendance', [StudentAttendanceController::class, 'index'])->name('attendance.index');
    Route::get('settings', [SettingController::class, 'edit'])->name('settings.edit');
    Route::get('settings/branding', [SettingController::class, 'editBranding'])->name('settings.branding.edit');
    Route::post('settings/branding', [SettingController::class, 'updateBranding'])->name('settings.branding.update');
    Route::get('settings/payment-gateways', [SettingController::class, 'editGateways'])->name('settings.gateways.edit');
    Route::post('settings/payment-gateways', [SettingController::class, 'updateGateways'])->name('settings.gateways.update');
    Route::get('settings/notifications', [SettingController::class, 'editNotifications'])->name('settings.notifications.edit');
    Route::post('settings/notifications', [SettingController::class, 'updateNotifications'])->name('settings.notifications.update');
    
    // Room Routes
    Route::resource('room', RoomController::class);

    // Notes
    Route::resource('notes', NoteController::class)->except(['show']);

    // Leave Types
    Route::resource('leave-types', LeaveTypeController::class)->except(['show']);

    // Leave Requests
    Route::resource('leave-requests', AdminLeaveRequestController::class)->only(['index','edit','update','destroy']);

    // Examinations
    Route::resource('exam-types', ExamTypeController::class)->except(['show']);
    Route::resource('exam-schedules', ExamScheduleController::class);
    Route::get('exam-results', [ExamScheduleController::class, 'results'])->name('exam-results.index');

    // Notifications (Parent Push)
    Route::resource('notifications', NotificationController::class)->except(['show']);
    Route::patch('notifications/{id}/toggle-status', [NotificationController::class, 'toggleStatus'])->name('notifications.toggle-status');

    // Admin Notifications (System alerts for admin)
    Route::get('admin-notifications', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'index'])->name('admin-notifications.index');
    Route::get('admin-notifications/recent', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'recent'])->name('admin-notifications.recent');
    Route::get('admin-notifications/unread-count', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'unreadCount'])->name('admin-notifications.unread-count');
    Route::match(['get', 'post'], 'admin-notifications/{id}/read', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'markAsRead'])->name('admin-notifications.read');
    Route::post('admin-notifications/mark-all-read', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'markAllAsRead'])->name('admin-notifications.mark-all-read');
    Route::delete('admin-notifications/{id}', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'destroy'])->name('admin-notifications.destroy');
    Route::delete('admin-notifications', [\App\Http\Controllers\Admin\AdminNotificationController::class, 'clearAll'])->name('admin-notifications.clear-all');
});
