<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ParentController;
use App\Http\Controllers\Api\TeacherController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public API routes
Route::post('/login', [AuthController::class, 'login']);

// Protected API routes (require authentication)
Route::middleware(['api.auth'])->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);
    
    // Parent specific routes
    Route::prefix('parent')->group(function () {
        Route::get('/dashboard', [ParentController::class, 'dashboard']);
        Route::get('/children', [ParentController::class, 'children']);
        Route::get('/homework', [ParentController::class, 'homework']);
        Route::get('/attendance', [ParentController::class, 'attendance']);
        Route::get('/fees', [ParentController::class, 'fees']);
        Route::get('/payment-settings', [ParentController::class, 'paymentSettings']);
        Route::post('/initiate-payment', [ParentController::class, 'initiatePayment']);
        Route::post('/verify-payment', [ParentController::class, 'verifyPayment']);
        Route::get('/exams', [ParentController::class, 'exams']);
        Route::get('/timetable', [ParentController::class, 'timetable']);
        Route::get('/leave-requests', [ParentController::class, 'leaveRequests']);
        Route::get('/leave-types', [ParentController::class, 'leaveTypes']);
        Route::post('/leave-requests', [ParentController::class, 'submitLeaveRequest']);
        Route::get('/site-name', [ParentController::class, 'siteName']);
        Route::get('/contact-info', [ParentController::class, 'contactInfo']);
        Route::get('/notifications', [ParentController::class, 'notifications']);
        Route::get('/notifications/count', [ParentController::class, 'notificationCount']);
        Route::post('/notifications/{id}/read', [ParentController::class, 'markNotificationRead']);
        Route::delete('/notifications/{id}', [ParentController::class, 'deleteNotification']);
        Route::post('/notifications/read-all', [ParentController::class, 'markAllNotificationsRead']);
        Route::get('/students/{id}', [ParentController::class, 'studentDetails']);
        Route::get('/profile', [ParentController::class, 'profile']);
        Route::post('/profile', [ParentController::class, 'updateProfile']);
        Route::post('/change-password', [ParentController::class, 'changePassword']);
        Route::post('/device-token', [ParentController::class, 'registerDeviceToken']);
        Route::delete('/device-token', [ParentController::class, 'unregisterDeviceToken']);
    });

    // Teacher specific routes
    Route::prefix('teacher')->group(function () {
        Route::get('/dashboard', [TeacherController::class, 'dashboard']);
    });
});
