@extends('layouts.teacher')

@section('title', 'Notifications')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h6 class="fw-semibold mb-0">Notifications</h6>
        <p class="text-neutral-600 mt-4 mb-0">Your notifications and alerts</p>
    </div>
    @if($notifications->where('read_at', null)->count() > 0)
        <form action="{{ route('teacher.notifications.mark-all-read') }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-outline-primary-600">
                <i class="ri-check-double-line me-1"></i> Mark All as Read
            </button>
        </form>
    @endif
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="card">
    <div class="card-body p-0">
        @if($notifications->count())
            <div class="notification-list">
                @foreach($notifications as $notification)
                    <div class="d-flex align-items-start gap-16 px-24 py-16 border-bottom {{ $notification->read_at ? 'bg-white' : 'bg-primary-50' }}">
                        <div class="w-48-px h-48-px {{ $notification->icon_bg ?? 'bg-primary-600' }} rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                            <i class="{{ $notification->icon ?? 'ri-notification-3-line' }} text-white text-xl"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-start justify-content-between">
                                <div>
                                    <h6 class="fw-semibold text-md text-primary-light mb-1">
                                        {{ $notification->title }}
                                        @if(!$notification->read_at)
                                            <span class="badge bg-primary-600 ms-2 text-xs">New</span>
                                        @endif
                                    </h6>
                                    <p class="mb-2 text-secondary-light">{{ $notification->message }}</p>
                                    <div class="d-flex align-items-center gap-12">
                                        <span class="text-xs text-neutral-500">
                                            <i class="ri-time-line me-1"></i>{{ $notification->created_at->diffForHumans() }}
                                        </span>
                                        <span class="badge bg-{{ $notification->type == 'leave_status' ? 'info' : ($notification->type == 'homework_submission' ? 'success' : 'primary') }}-100 text-{{ $notification->type == 'leave_status' ? 'info' : ($notification->type == 'homework_submission' ? 'success' : 'primary') }}-600 text-xs">
                                            {{ ucfirst(str_replace('_', ' ', $notification->type)) }}
                                        </span>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    @if($notification->link)
                                        <a href="{{ route('teacher.notifications.read', $notification->id) }}" class="btn btn-sm btn-primary-600">
                                            <i class="ri-external-link-line me-1"></i> View
                                        </a>
                                    @endif
                                    <form action="{{ route('teacher.notifications.destroy', $notification->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger-600" onclick="return confirm('Delete this notification?');">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            
            <div class="px-24 py-16">
                {{ $notifications->links() }}
            </div>
        @else
            <div class="text-center py-60">
                <iconify-icon icon="mdi:bell-off-outline" class="text-6xl text-neutral-300"></iconify-icon>
                <h6 class="mt-16 text-neutral-600">No Notifications</h6>
                <p class="text-secondary-light">You're all caught up! No new notifications.</p>
            </div>
        @endif
    </div>
</div>
@endsection
