@extends('layouts.teacher')

@section('title', 'Student Attendance')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Student Attendance</h1>
        <div class="">
            <span class="text-secondary-light">Mark attendance for your class</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<div class="card h-100">
    <div class="card-body p-0 dataTable-wrapper">
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
            <form class="d-flex flex-wrap align-items-end gap-16" method="GET" action="{{ route('teacher.attendance.index') }}">
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Date</label>
                    <input type="date" name="date" class="form-control" value="{{ $date }}">
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Class</label>
                    <select name="class_id" class="form-control form-select">
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ $classId == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Section</label>
                    <select name="section_id" class="form-control form-select">
                        <option value="">Select Section</option>
                        @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ $sectionId == $section->id ? 'selected' : '' }}>{{ $section->name }}</option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-primary-600">
                    Load Students
                </button>
            </form>
        </div>

        <div class="p-20">
            @if($students->count())
            <form action="{{ route('teacher.attendance.store') }}" method="POST">
                @csrf
                <input type="hidden" name="date" value="{{ $date }}">
                <input type="hidden" name="class_id" value="{{ $classId }}">
                <input type="hidden" name="section_id" value="{{ $sectionId }}">

                <div class="table-responsive">
                    <table class="table bordered-table mb-0">
                        <thead>
                            <tr>
                                <th>Student</th>
                                <th>Admission No</th>
                                <th>Status</th>
                                <th>Remark</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($students as $student)
                            @php
                                $record = $existing->get($student->id);
                                $isOnLeave = isset($approvedLeaves) && $approvedLeaves->has($student->id);
                                $currentStatus = $record->status ?? ($isOnLeave ? 'leave' : 'present');
                            @endphp
                            <tr>
                                <td>{{ $student->name }}</td>
                                <td>{{ $student->admission_no }}</td>
                                <td>
                                    <select name="attendance[{{ $student->id }}][status]" class="form-control form-select" {{ $isOnLeave ? 'disabled' : '' }}>
                                        <option value="present" {{ $currentStatus == 'present' ? 'selected' : '' }}>Present</option>
                                        <option value="absent" {{ $currentStatus == 'absent' ? 'selected' : '' }}>Absent</option>
                                        <option value="late" {{ $currentStatus == 'late' ? 'selected' : '' }}>Late</option>
                                        <option value="leave" {{ $currentStatus == 'leave' ? 'selected' : '' }}>Leave</option>
                                    </select>
                                    @if($isOnLeave)
                                        <input type="hidden" name="attendance[{{ $student->id }}][status]" value="leave">
                                        <small class="text-warning d-block mt-1">Approved leave</small>
                                    @endif
                                </td>
                                <td>
                                    <input type="text" name="attendance[{{ $student->id }}][remark]" class="form-control"
                                        value="{{ $record->remark ?? '' }}" placeholder="Optional">
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-center mt-3">
                    <button type="submit" class="btn btn-primary-600 px-28 py-12 radius-8">
                        Save Attendance
                    </button>
                </div>
            </form>
            @else
                <p class="mb-0 text-secondary-light">Select date, class and section, then click "Load Students" to mark attendance.</p>
            @endif
        </div>
    </div>
</div>
@endsection



