@php
    $adminNotifications = \App\Models\AdminNotification::orderByDesc('created_at')->limit(10)->get();
    $unreadCount = \App\Models\AdminNotification::unread()->count();
@endphp
<div class="navbar-header shadow-1">
  <div class="row align-items-center justify-content-between">
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-4">
        <button type="button" class="sidebar-mobile-toggle" aria-label="Sidebar Mobile Toggler Button">
          <iconify-icon icon="heroicons:bars-3-solid" class="icon"></iconify-icon>
        </button>
        <form class="navbar-search">
          <input type="text" class="bg-transparent" name="search" placeholder="Search">
          <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>
        </form>
      </div>
    </div>
    <div class="col-auto">
      <div class="d-flex flex-wrap align-items-center gap-3">
        
        <!-- Notification Bell Dropdown -->
        <div class="dropdown">
          <button class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center position-relative" 
                  type="button" 
                  id="notificationDropdown" 
                  data-bs-toggle="dropdown" 
                  aria-expanded="false"
                  aria-label="Notifications">
            <iconify-icon icon="mdi:bell-outline" class="text-xl text-primary-light"></iconify-icon>
            @if($unreadCount > 0)
              <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" style="font-size: 10px; padding: 3px 6px;">
                {{ $unreadCount > 99 ? '99+' : $unreadCount }}
              </span>
            @endif
          </button>
          <div class="dropdown-menu dropdown-menu-end p-0 shadow-lg" aria-labelledby="notificationDropdown" style="min-width: 360px; max-height: 450px; overflow-y: auto;">
            <div class="d-flex align-items-center justify-content-between px-16 py-12 border-bottom bg-neutral-50">
              <h6 class="mb-0 fw-semibold text-md">Notifications</h6>
              @if($unreadCount > 0)
                <form action="{{ route('admin.admin-notifications.mark-all-read') }}" method="POST" class="d-inline">
                  @csrf
                  <button type="submit" class="btn btn-link btn-sm p-0 text-primary-600 text-decoration-none">
                    Mark all as read
                  </button>
                </form>
              @endif
            </div>
            
            @if($adminNotifications->count())
              <div class="notification-list">
                @foreach($adminNotifications as $notification)
                  <a href="{{ route('admin.admin-notifications.read', $notification->id) }}" 
                     class="d-flex align-items-start gap-12 px-16 py-12 border-bottom text-decoration-none {{ $notification->read_at ? 'bg-white' : 'bg-primary-50' }}">
                    <div class="w-40-px h-40-px {{ $notification->icon_bg ?? 'bg-primary-600' }} rounded-circle d-flex justify-content-center align-items-center flex-shrink-0">
                      <i class="{{ $notification->icon ?? 'ri-notification-3-line' }} text-white"></i>
                    </div>
                    <div class="flex-grow-1">
                      <div class="d-flex align-items-center justify-content-between">
                        <h6 class="fw-semibold text-sm text-primary-light mb-1">{{ $notification->title }}</h6>
                        @if(!$notification->read_at)
                          <span class="w-8-px h-8-px bg-primary-600 rounded-circle"></span>
                        @endif
                      </div>
                      <p class="mb-1 text-secondary-light text-xs">{{ \Illuminate\Support\Str::limit($notification->message, 60) }}</p>
                      <span class="text-xs text-neutral-500">{{ $notification->created_at->diffForHumans() }}</span>
                    </div>
                  </a>
                @endforeach
              </div>
              <div class="text-center py-12 border-top">
                <a href="{{ route('admin.admin-notifications.index') }}" class="text-primary-600 fw-semibold text-sm hover-underline">
                  View All Notifications
                </a>
              </div>
            @else
              <div class="text-center py-40">
                <iconify-icon icon="mdi:bell-off-outline" class="text-4xl text-neutral-300"></iconify-icon>
                <p class="mb-0 text-secondary-light mt-8 text-sm">No notifications yet</p>
              </div>
            @endif
          </div>
        </div>

        <!-- Theme Toggle -->
        <button type="button" data-theme-toggle
          class="w-40-px h-40-px bg-neutral-200 rounded-circle d-flex justify-content-center align-items-center" aria-label="Dark & Light Mode Button"></button>
      </div>
    </div>
  </div>
</div>
