@extends('layouts.parent')

@section('title', 'Student Details')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Student Details</h1>
        <span class="text-secondary-light">Admission and attendance snapshot</span>
    </div>
    <a href="{{ route('parent.dashboard') }}" class="btn btn-outline-primary">← Back to Dashboard</a>
</div>

@php
    $photo = $student->photo ? asset('storage/'.$student->photo) : asset('assets/images/users/user1.png');
    $dob = $student->date_of_birth ? \Carbon\Carbon::parse($student->date_of_birth)->format('d M Y') : '-';
    $gender = $student->gender ? ucfirst($student->gender) : '-';
@endphp

<div class="row gy-3">
    <div class="col-lg-4">
        <div class="shadow-1 radius-12 bg-base h-100 p-20 text-center">
            <img src="{{ $photo }}" alt="Photo" class="rounded-circle object-fit-cover mb-12" style="width:120px;height:120px;">
            <h5 class="fw-semibold text-primary-light mb-2">{{ $student->name }}</h5>
            <p class="mb-1 text-secondary-light text-sm">Admission No: <span class="text-success fw-semibold">{{ $student->admission_no ?? '-' }}</span></p>
            <p class="mb-0 text-secondary-light text-sm">Roll Number: <span class="fw-semibold">{{ $student->roll_number ?? '-' }}</span></p>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="shadow-1 radius-12 bg-base h-100 p-20">
            <h6 class="fw-semibold mb-12">Admission Details</h6>
            <div class="row g-3 text-sm text-secondary-light">
                <div class="col-md-6">
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Class:</span> {{ $student->schoolClass->name ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Section:</span> {{ $student->section->name ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Batch:</span> {{ $student->batch->name ?? '-' }}</p>
                </div>
                <div class="col-md-6">
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Academic Year:</span> {{ $student->academicYear->name ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Gender:</span> {{ $gender }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Date Of Birth:</span> {{ $dob }}</p>
                </div>
                <div class="col-12">
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Address:</span> {{ $student->current_address ?? $student->address ?? '-' }}</p>
                    <p class="mb-0"><span class="fw-semibold text-neutral-800">City/State/Pin:</span> {{ $student->city ?? '-' }}, {{ $student->state ?? '-' }} {{ $student->zip_code ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row gy-3 mt-1">
    <div class="col-lg-5">
        <div class="shadow-1 radius-12 bg-base h-100 p-20">
            <h6 class="fw-semibold mb-12">Attendance (recent)</h6>
            <div class="d-flex gap-3 flex-wrap mb-12">
                <span class="badge bg-success-subtle text-success">Present: {{ $attendanceStats['present'] }}</span>
                <span class="badge bg-danger-subtle text-danger">Absent: {{ $attendanceStats['absent'] }}</span>
                <span class="badge bg-warning-subtle text-warning">Late: {{ $attendanceStats['late'] }}</span>
            </div>
            @if($attendance->count())
                <div class="table-responsive">
                    <table class="table table-sm mb-0">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Status</th>
                                <th>Teacher</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($attendance as $att)
                            <tr>
                                <td>{{ $att->date ? $att->date->format('d M Y') : '-' }}</td>
                                <td>
                                    @php
                                        $status = strtolower($att->status);
                                        $badge = 'bg-secondary-subtle text-secondary';
                                        if($status === 'present') $badge = 'bg-success-subtle text-success';
                                        elseif($status === 'absent') $badge = 'bg-danger-subtle text-danger';
                                        elseif($status === 'late') $badge = 'bg-warning-subtle text-warning';
                                    @endphp
                                    <span class="badge {{ $badge }}">{{ ucfirst($status) }}</span>
                                </td>
                                <td>{{ $att->teacher->name ?? '-' }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="mb-0 text-secondary-light">No attendance records yet.</p>
            @endif
        </div>
    </div>
    <div class="col-lg-7">
        <div class="shadow-1 radius-12 bg-base h-100 p-20">
            <h6 class="fw-semibold mb-12">Contact & Guardian</h6>
            <div class="row g-3 text-sm text-secondary-light">
                <div class="col-md-6">
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Email:</span> {{ $student->email ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Phone:</span> {{ $student->phone ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Blood Group:</span> {{ $student->blood_group ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">City:</span> {{ $student->city ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">State:</span> {{ $student->state ?? '-' }}</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Zip Code:</span> {{ $student->zip_code ?? '-' }}</p>
                </div>
                <div class="col-md-6">
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Father:</span> {{ $student->father_name ?? '-' }} @if($student->father_phone) ({{ $student->father_phone }}) @endif</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Mother:</span> {{ $student->mother_name ?? '-' }} @if($student->mother_phone) ({{ $student->mother_phone }}) @endif</p>
                    <p class="mb-1"><span class="fw-semibold text-neutral-800">Guardian:</span> {{ $student->guardian_name ?? '-' }} @if($student->guardian_phone) ({{ $student->guardian_phone }}) @endif</p>
                </div>
                <div class="col-12">
                    <p class="mb-0"><span class="fw-semibold text-neutral-800">Permanent Address:</span> {{ $student->permanent_address ?? '-' }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row gy-3 mt-1">
    <div class="col-12">
        <div class="shadow-1 radius-12 bg-base h-100 p-20">
            <h6 class="fw-semibold mb-12">Exams &amp; Results</h6>
            @if(isset($examResults) && $examResults->count())
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Exam</th>
                                <th>Subject</th>
                                <th>Class / Section</th>
                                <th>Date</th>
                                <th>Marks</th>
                                <th>Grade</th>
                                <th>Absent</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($examResults as $result)
                                @php
                                    $schedule = $result->examSchedule;
                                @endphp
                                <tr>
                                    <td>{{ $schedule->examType->name ?? '-' }}</td>
                                    <td>{{ $schedule->subject->name ?? '-' }}</td>
                                    <td>
                                        {{ $schedule->schoolClass->name ?? '-' }}
                                        @if($schedule->section)
                                            / {{ $schedule->section->name }}
                                        @endif
                                    </td>
                                    <td>
                                        {{ $schedule->exam_date ? $schedule->exam_date->format('d M Y') : '-' }}
                                    </td>
                                    <td>
                                        {{ $result->marks_obtained ?? '-' }}
                                        @if($schedule->max_marks)
                                            / {{ $schedule->max_marks }}
                                        @endif
                                    </td>
                                    <td>{{ $result->grade ?? '-' }}</td>
                                    <td>{{ $result->is_absent ? 'Yes' : 'No' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="mb-0 text-secondary-light">No exam results recorded yet for this student.</p>
            @endif
        </div>
    </div>
</div>
@endsection


