@extends('layouts.parent')

@section('title', 'Leave Requests')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Leave Requests</h1>
        <span class="text-secondary-light">Submit and track your leave requests</span>
    </div>
    <a href="{{ route('parent.leave-requests.create') }}" class="btn btn-primary-600">New Request</a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
        <h6 class="text-lg fw-semibold mb-0">Requests</h6>
    </div>
    <div class="card-body p-20">
        @if($requests->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>Student</th>
                            <th>Type</th>
                            <th>Date Range</th>
                            <th>Status</th>
                            <th>Admin Remarks</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($requests as $req)
                        <tr>
                            <td>{{ $req->student->name ?? '-' }}</td>
                            <td>{{ $req->leaveType->name ?? '-' }}</td>
                            <td>{{ $req->from_date->format('d M Y') }} - {{ $req->to_date->format('d M Y') }}</td>
                            <td>
                                @php
                                    $status = $req->status;
                                    $badge = 'bg-secondary-subtle text-secondary';
                                    if($status === 'approved') $badge = 'bg-success-subtle text-success';
                                    elseif($status === 'rejected') $badge = 'bg-danger-subtle text-danger';
                                    elseif($status === 'pending') $badge = 'bg-warning-subtle text-warning';
                                @endphp
                                <span class="badge {{ $badge }}">{{ ucfirst($status) }}</span>
                            </td>
                            <td>{{ $req->admin_remarks ?? '-' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-12">
                {{ $requests->links() }}
            </div>
        @else
            <p class="mb-0 text-secondary-light">No leave requests yet.</p>
        @endif
    </div>
</div>
@endsection


