@extends('layouts.parent')

@section('title', 'New Leave Request')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">New Leave Request</h1>
        <span class="text-secondary-light">Fill the details and submit to admin</span>
    </div>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('parent.leave-requests.store') }}" method="POST" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Request Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Child <span class="text-danger-600">*</span></label>
                            <select name="student_id" class="form-select" required>
                                <option value="">Select child</option>
                                @foreach($students as $student)
                                    <option value="{{ $student->id }}" {{ old('student_id') == $student->id ? 'selected' : '' }}>
                                        {{ $student->name }} ({{ $student->admission_no }})
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Leave Type</label>
                            <select name="leave_type_id" class="form-select">
                                <option value="">Select type</option>
                                @foreach($leaveTypes as $type)
                                    <option value="{{ $type->id }}" {{ old('leave_type_id') == $type->id ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">From Date <span class="text-danger-600">*</span></label>
                            <input type="date" name="from_date" class="form-control" required value="{{ old('from_date') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">To Date <span class="text-danger-600">*</span></label>
                            <input type="date" name="to_date" class="form-control" required value="{{ old('to_date') }}">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Reason</label>
                            <textarea name="reason" rows="3" class="form-control" placeholder="Enter reason">{{ old('reason') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('parent.leave-requests.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Submit Request
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


