@extends('layouts.parent')

@section('title', 'Homework')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Assignment</h1>
        <span class="text-secondary-light">View assignment for your children</span>
    </div>
    <a href="{{ route('parent.dashboard') }}" class="btn btn-outline-primary">← Back to Dashboard</a>
</div>

<!-- Student Selection -->
@if($children->count() > 1)
<div class="shadow-1 radius-12 bg-base p-20 mb-24">
    <h6 class="fw-semibold mb-12 text-primary-light">Select Child</h6>
    <form method="GET" action="{{ route('parent.homework.index') }}" class="d-flex gap-3 align-items-end flex-wrap">
        <div class="flex-grow-1" style="min-width: 200px;">
            <label class="form-label text-sm text-secondary-light mb-2">Child</label>
            <select name="student_id" class="form-select" onchange="this.form.submit()">
                <option value="">-- Select Child --</option>
                @foreach($children as $child)
                    <option value="{{ $child->id }}" {{ $selectedStudentId == $child->id ? 'selected' : '' }}>
                        {{ $child->name }} ({{ $child->schoolClass->name ?? '-' }} @if($child->section) - {{ $child->section->name }}@endif)
                    </option>
                @endforeach
            </select>
        </div>
    </form>
</div>
@endif

@if($selectedStudent)
    @php
        $photo = $selectedStudent->photo ? asset('storage/'.$selectedStudent->photo) : asset('assets/images/users/user1.png');
    @endphp
    
    <!-- Student Info Card -->
    <div class="shadow-1 radius-12 bg-base p-20 mb-24">
        <div class="d-flex align-items-center gap-16 flex-wrap">
            <img src="{{ $photo }}" alt="{{ $selectedStudent->name }}" class="rounded-circle object-fit-cover" style="width: 80px; height: 80px;">
            <div class="flex-grow-1">
                <h5 class="fw-semibold mb-2 text-primary-light">{{ $selectedStudent->name }}</h5>
                <p class="mb-1 text-sm text-secondary-light">
                    <span class="fw-semibold">Admission No:</span> 
                    <span class="text-success">{{ $selectedStudent->admission_no ?? '-' }}</span>
                </p>
                <p class="mb-0 text-sm text-secondary-light">
                    <span class="fw-semibold">Class:</span> 
                    {{ $selectedStudent->schoolClass->name ?? '-' }} 
                    @if($selectedStudent->section) ({{ $selectedStudent->section->name }})@endif
                </p>
            </div>
        </div>
    </div>

    <!-- Homework List -->
    <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
        <div class="card-header border-bottom bg-base py-16 px-24">
            <h6 class="text-lg fw-semibold mb-0">Assignments</h6>
        </div>
        <div class="card-body p-20">
            @if($homework->count() > 0)
                <div class="row gy-3">
                    @foreach($homework as $hw)
                        <div class="col-12">
                            <div class="shadow-1 radius-12 bg-base p-20 border">
                                <div class="d-flex align-items-start justify-content-between gap-3 mb-12">
                                    <div class="flex-grow-1">
                                        <h5 class="fw-semibold mb-2 text-primary-light">{{ $hw->title }}</h5>
                                        <div class="d-flex flex-wrap gap-3 text-sm text-secondary-light mb-2">
                                            <span><i class="ri-user-line"></i> {{ $hw->teacher->name ?? '-' }}</span>
                                            <span><i class="ri-book-open-line"></i> {{ $hw->subject->name ?? '-' }}</span>
                                            <span><i class="ri-calendar-line"></i> Assigned: {{ $hw->assigned_date->format('d M Y') }}</span>
                                            <span><i class="ri-time-line"></i> Due: {{ $hw->due_date->format('d M Y') }}</span>
                                        </div>
                                        @if($hw->description)
                                        <p class="text-secondary-light mb-0">{{ \Illuminate\Support\Str::limit($hw->description, 150) }}</p>
                                        @endif
                                    </div>
                                    <div>
                                        @php
                                            $statusClass = 'bg-secondary-subtle text-secondary';
                                            if($hw->status === 'active') $statusClass = 'bg-success-subtle text-success';
                                            elseif($hw->status === 'completed') $statusClass = 'bg-primary-subtle text-primary';
                                            elseif($hw->status === 'cancelled') $statusClass = 'bg-danger-subtle text-danger';
                                        @endphp
                                        <span class="badge {{ $statusClass }} mb-2 d-block">{{ ucfirst($hw->status) }}</span>
                                        
                                        @php
                                            $submission = $hw->submissions->firstWhere('student_id', $selectedStudent->id);
                                        @endphp
                                        @if($submission)
                                            @if($submission->status === 'late')
                                                <span class="badge bg-danger-subtle text-danger">Late Submit</span>
                                            @else
                                                <span class="badge bg-success-subtle text-success">Submitted</span>
                                            @endif
                                            <small class="d-block text-secondary-light mt-1">{{ $submission->submitted_date->format('d M Y') }}</small>
                                        @else
                                            <span class="badge bg-warning-subtle text-warning">Not Submitted</span>
                                        @endif
                                    </div>
                                </div>
                                @if($hw->attachments && count($hw->attachments) > 0)
                                <div class="mt-12 pt-12 border-top">
                                    <p class="text-sm fw-semibold text-primary-light mb-2">Attachments:</p>
                                    <div class="d-flex flex-wrap gap-2">
                                        @foreach($hw->attachments as $attachment)
                                        <a href="{{ asset('storage/'.$attachment) }}" target="_blank" class="badge bg-primary-subtle text-primary p-2 text-decoration-none">
                                            <i class="ri-file-line"></i> {{ basename($attachment) }}
                                        </a>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                                <div class="mt-12 d-flex justify-content-end">
                                    <a href="{{ route('parent.homework.show', $hw->id) }}" class="btn btn-sm btn-outline-primary">View Details</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="mb-0 text-secondary-light text-center py-20">No assignments found for this student.</p>
            @endif
        </div>
    </div>
@else
    <div class="shadow-1 radius-12 bg-base p-20 text-center">
        <p class="mb-0 text-secondary-light">
            @if($children->count() > 1)
                Please select a child to view assignments.
            @else
                No children linked to your account.
            @endif
        </p>
    </div>
@endif
@endsection
