@extends('layouts.parent')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Exams &amp; Results</h1>
        <div class="">
            <a href="{{ route('parent.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Exams / Results</span>
        </div>
    </div>
</div>

@if(isset($children) && $children->count())
    <div class="shadow-1 radius-12 bg-base mb-24">
        <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
            <h6 class="text-lg fw-semibold mb-0">Your Children</h6>
            <span class="text-secondary-light text-sm">Quick links to student details</span>
        </div>
        <div class="card-body p-20">
            <div class="row g-3">
                @foreach($children as $student)
                    @php
                        $photo = $student->photo ? asset('storage/'.$student->photo) : asset('assets/images/users/user1.png');
                    @endphp
                    <div class="col-12 col-md-6 col-xl-4">
                        <div class="shadow-1 radius-12 bg-neutral-50 h-100 p-16 d-flex align-items-center gap-12 justify-content-between">
                            <div class="d-flex align-items-center gap-12">
                                <img src="{{ $photo }}" alt="Photo" class="rounded-circle object-fit-cover" style="width:56px;height:56px;">
                                <div>
                                    <h6 class="fw-semibold mb-4 text-primary-light">{{ $student->name }}</h6>
                                    <p class="mb-0 text-secondary-light text-sm">
                                        <span class="fw-semibold">Class:</span>
                                        {{ $student->schoolClass->name ?? '-' }}
                                        @if($student->section)
                                            / {{ $student->section->name }}
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <a href="{{ route('parent.students.show', $student->id) }}" class="btn btn-sm btn-outline-primary">
                                View Details
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-body p-20">
        @if($examSchedules->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>Exam</th>
                            <th>Subject</th>
                            <th>Class / Section</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Student</th>
                            <th>Marks</th>
                            <th>Absent</th>
                            <th>Grade</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($examSchedules as $schedule)
                            @foreach($schedule->results as $result)
                                <tr>
                                    <td>{{ $schedule->examType->name ?? '-' }}</td>
                                    <td>{{ $schedule->subject->name ?? '-' }}</td>
                                    <td>{{ $schedule->schoolClass->name ?? '-' }} @if($schedule->section)/ {{ $schedule->section->name }}@endif</td>
                                    <td>{{ $schedule->exam_date->format('d M Y') }}</td>
                                    <td>{{ \Carbon\Carbon::parse($schedule->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($schedule->end_time)->format('h:i A') }}</td>
                                    <td>{{ $result->student->name }}</td>
                                    <td>{{ $result->marks_obtained ?? '-' }} @if($schedule->max_marks) / {{ $schedule->max_marks }} @endif</td>
                                    <td>{{ $result->is_absent ? 'Yes' : 'No' }}</td>
                                    <td>{{ $result->grade ?? '-' }}</td>
                                </tr>
                            @endforeach
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p class="mb-0 text-secondary-light">No exam results available yet.</p>
        @endif
    </div>
</div>
@endsection


