@extends('layouts.parent')

@section('title', 'Attendance')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div>
        <h1 class="fw-semibold mb-1 h6 text-primary-light">Attendance</h1>
        <span class="text-secondary-light">View attendance records for your children</span>
    </div>
    <a href="{{ route('parent.dashboard') }}" class="btn btn-outline-primary">← Back to Dashboard</a>
</div>

<!-- Student Selection -->
@if($children->count() > 1)
<div class="shadow-1 radius-12 bg-base p-20 mb-24">
    <h6 class="fw-semibold mb-12 text-primary-light">Select Child</h6>
    <form method="GET" action="{{ route('parent.attendance.index') }}" class="d-flex gap-3 align-items-end flex-wrap">
        <div class="flex-grow-1" style="min-width: 200px;">
            <label class="form-label text-sm text-secondary-light mb-2">Child</label>
            <select name="student_id" class="form-select" onchange="this.form.submit()">
                <option value="">-- Select Child --</option>
                @foreach($children as $child)
                    <option value="{{ $child->id }}" {{ $selectedStudentId == $child->id ? 'selected' : '' }}>
                        {{ $child->name }} ({{ $child->schoolClass->name ?? '-' }} @if($child->section) - {{ $child->section->name }}@endif)
                    </option>
                @endforeach
            </select>
        </div>
        <div style="min-width: 150px;">
            <label class="form-label text-sm text-secondary-light mb-2">Start Date</label>
            <input type="date" name="start_date" class="form-select" value="{{ $startDate }}" onchange="this.form.submit()">
        </div>
        <div style="min-width: 150px;">
            <label class="form-label text-sm text-secondary-light mb-2">End Date</label>
            <input type="date" name="end_date" class="form-select" value="{{ $endDate }}" onchange="this.form.submit()">
        </div>
    </form>
</div>
@elseif($children->count() == 1)
<div class="shadow-1 radius-12 bg-base p-20 mb-24">
    <form method="GET" action="{{ route('parent.attendance.index') }}" class="d-flex gap-3 align-items-end flex-wrap">
        <input type="hidden" name="student_id" value="{{ $children->first()->id }}">
        <div style="min-width: 150px;">
            <label class="form-label text-sm text-secondary-light mb-2">Start Date</label>
            <input type="date" name="start_date" class="form-select" value="{{ $startDate }}" onchange="this.form.submit()">
        </div>
        <div style="min-width: 150px;">
            <label class="form-label text-sm text-secondary-light mb-2">End Date</label>
            <input type="date" name="end_date" class="form-select" value="{{ $endDate }}" onchange="this.form.submit()">
        </div>
    </form>
</div>
@endif

@if($selectedStudent)
    @php
        $photo = $selectedStudent->photo ? asset('storage/'.$selectedStudent->photo) : asset('assets/images/users/user1.png');
    @endphp
    
    <!-- Student Info Card -->
    <div class="shadow-1 radius-12 bg-base p-20 mb-24">
        <div class="d-flex align-items-center gap-16 flex-wrap">
            <img src="{{ $photo }}" alt="{{ $selectedStudent->name }}" class="rounded-circle object-fit-cover" style="width: 80px; height: 80px;">
            <div class="flex-grow-1">
                <h5 class="fw-semibold mb-2 text-primary-light">{{ $selectedStudent->name }}</h5>
                <p class="mb-1 text-sm text-secondary-light">
                    <span class="fw-semibold">Admission No:</span> 
                    <span class="text-success">{{ $selectedStudent->admission_no ?? '-' }}</span>
                </p>
                <p class="mb-0 text-sm text-secondary-light">
                    <span class="fw-semibold">Class:</span> 
                    {{ $selectedStudent->schoolClass->name ?? '-' }} 
                    @if($selectedStudent->section) ({{ $selectedStudent->section->name }})@endif
                </p>
            </div>
        </div>
    </div>

    <!-- Attendance Stats -->
    @if($attendanceStats)
    <div class="row gy-3 mb-24">
        <div class="col-md-3 col-sm-6">
            <div class="shadow-1 radius-12 bg-base p-16 text-center">
                <p class="text-secondary-light text-sm mb-4">Total Days</p>
                <h3 class="h4 fw-semibold mb-0">{{ $attendanceStats['total'] }}</h3>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="shadow-1 radius-12 bg-base p-16 text-center">
                <p class="text-secondary-light text-sm mb-4">Present</p>
                <h3 class="h4 fw-semibold mb-0 text-success">{{ $attendanceStats['present'] }}</h3>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="shadow-1 radius-12 bg-base p-16 text-center">
                <p class="text-secondary-light text-sm mb-4">Absent</p>
                <h3 class="h4 fw-semibold mb-0 text-danger">{{ $attendanceStats['absent'] }}</h3>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="shadow-1 radius-12 bg-base p-16 text-center">
                <p class="text-secondary-light text-sm mb-4">Attendance Rate</p>
                <h3 class="h4 fw-semibold mb-0 text-primary-600">{{ $attendanceStats['percentage'] }}%</h3>
            </div>
        </div>
    </div>

    <!-- Progress Bar -->
    <div class="shadow-1 radius-12 bg-base p-20 mb-24">
        <div class="d-flex align-items-center justify-content-between mb-8">
            <span class="fw-semibold text-primary-light">Overall Attendance</span>
            <span class="text-secondary-light text-sm">{{ $attendanceStats['percentage'] }}%</span>
        </div>
        <div class="progress" style="height: 12px;">
            <div class="progress-bar bg-success" role="progressbar" style="width: {{ $attendanceStats['percentage'] }}%"></div>
        </div>
        <div class="d-flex gap-3 mt-12 flex-wrap">
            <span class="badge bg-success-subtle text-success">Present: {{ $attendanceStats['present'] }}</span>
            <span class="badge bg-danger-subtle text-danger">Absent: {{ $attendanceStats['absent'] }}</span>
            @if($attendanceStats['late'] > 0)
                <span class="badge bg-warning-subtle text-warning">Late: {{ $attendanceStats['late'] }}</span>
            @endif
            @if($attendanceStats['leave'] > 0)
                <span class="badge bg-info-subtle text-info">Leave: {{ $attendanceStats['leave'] }}</span>
            @endif
        </div>
    </div>
    @endif

    <!-- Attendance Records Table -->
    <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
        <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
            <h6 class="text-lg fw-semibold mb-0">Attendance Records</h6>
            <span class="text-secondary-light text-sm">
                {{ \Carbon\Carbon::parse($startDate)->format('d M Y') }} - {{ \Carbon\Carbon::parse($endDate)->format('d M Y') }}
            </span>
        </div>
        <div class="card-body p-20">
            @if($attendanceRecords->count() > 0)
                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Day</th>
                                <th>Status</th>
                                <th>Teacher</th>
                                <th>Class</th>
                                <th>Section</th>
                                <th>Remark</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($attendanceRecords as $record)
                                <tr>
                                    <td>{{ $record->date ? $record->date->format('d M Y') : '-' }}</td>
                                    <td>{{ $record->date ? $record->date->format('l') : '-' }}</td>
                                    <td>
                                        @php
                                            $status = strtolower($record->status);
                                            $badge = 'bg-secondary-subtle text-secondary';
                                            if($status === 'present') $badge = 'bg-success-subtle text-success';
                                            elseif($status === 'absent') $badge = 'bg-danger-subtle text-danger';
                                            elseif($status === 'late') $badge = 'bg-warning-subtle text-warning';
                                            elseif($status === 'leave') $badge = 'bg-info-subtle text-info';
                                        @endphp
                                        <span class="badge {{ $badge }}">{{ ucfirst($status) }}</span>
                                    </td>
                                    <td>{{ $record->teacher->name ?? '-' }}</td>
                                    <td>{{ $record->schoolClass->name ?? '-' }}</td>
                                    <td>{{ $record->section->name ?? '-' }}</td>
                                    <td>{{ $record->remark ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="mb-0 text-secondary-light text-center py-20">No attendance records found for the selected date range.</p>
            @endif
        </div>
    </div>
@else
    <div class="shadow-1 radius-12 bg-base p-20 text-center">
        <p class="mb-0 text-secondary-light">
            @if($children->count() > 1)
                Please select a child to view attendance records.
            @else
                No children linked to your account.
            @endif
        </p>
    </div>
@endif
@endsection
