<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="Tuition Center Management System - Admin Dashboard">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>@yield('title', 'Admin') - Tuition Management System</title>
  <link rel="icon" type="image/png" href="{{ asset('assets/images/favicon.png') }}" sizes="16x16">
  <!-- remix icon font css  -->
  <link rel="stylesheet" href="{{ asset('assets/css/remixicon.css') }}">
  <!-- BootStrap css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/bootstrap.min.css') }}">
  <!-- Apex Chart css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/apexcharts.css') }}">
  <!-- Data Table css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/dataTables.min.css') }}">
  <!-- Date picker css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/flatpickr.min.css') }}">
  <!-- Calendar css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/full-calendar.css') }}">
  <!-- calendar -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/calendar.css') }}">
  <!-- main css -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
  <!-- Debug CSS for overlay fix -->
  <link rel="stylesheet" href="{{ asset('assets/css/debug-overlay.css') }}">
  <!-- Override external CSS for sidebar layout - must be after style.css -->
  <style>
    /* CRITICAL FIX: Ensure sidebar spacing works correctly */
    html, body {
      margin: 0 !important;
      padding: 0 !important;
      overflow-x: hidden !important;
    }
    
    /* Sidebar positioning - must be fixed and on top */
    .sidebar {
      position: fixed !important;
      left: 0 !important;
      top: 0 !important;
      z-index: 999 !important;
      height: 100vh !important;
      width: 15.625rem !important;
      overflow-y: auto !important;
    }
    
    @media (min-width: 1200px) {
      .sidebar {
        width: 13.75rem !important;
        left: 0 !important;
      }
    }
    
    @media (min-width: 1400px) {
      .sidebar {
        width: 17.1875rem !important;
      }
    }
    
    @media (min-width: 1650px) {
      .sidebar {
        width: 19.5rem !important;
      }
    }
    
    /* Override external CSS - Fix dashboard-main margin to push content away from sidebar */
    .dashboard-main,
    main.dashboard-main {
      margin-left: 0 !important;
      margin-inline-start: 0 !important;
      margin-right: 0 !important;
      margin-inline-end: 0 !important;
      display: flex !important;
      flex-direction: column !important;
      width: 100% !important;
      min-height: 100vh !important;
      position: relative !important;
      padding-left: 0 !important;
      left: 0 !important;
      transition: none !important;
      align-items: stretch !important;
      align-content: flex-start !important;
    }
    
    /* For mobile/tablet - sidebar is hidden by default, so full width */
    @media (max-width: 1199px) {
      .dashboard-main,
      main.dashboard-main {
        margin-left: 0 !important;
        margin-inline-start: 0 !important;
        width: 100% !important;
        max-width: 100% !important;
      }
    }
    
    @media (min-width: 1200px) {
      .dashboard-main,
      main.dashboard-main {
        margin-left: 13.75rem !important;
        margin-inline-start: 13.75rem !important;
        width: calc(100% - 13.75rem) !important;
        max-width: calc(100% - 13.75rem) !important;
        padding-left: 0 !important;
      }
    }
    
    @media (min-width: 1400px) {
      .dashboard-main,
      main.dashboard-main {
        margin-left: 17.1875rem !important;
        margin-inline-start: 17.1875rem !important;
        width: calc(100% - 17.1875rem) !important;
        max-width: calc(100% - 17.1875rem) !important;
        padding-left: 0 !important;
      }
    }
    
    @media (min-width: 1650px) {
      .dashboard-main,
      main.dashboard-main {
        margin-left: 19.5rem !important;
        margin-inline-start: 19.5rem !important;
        width: calc(100% - 19.5rem) !important;
        max-width: calc(100% - 19.5rem) !important;
        padding-left: 0 !important;
      }
    }
    
    /* Ensure topbar stays at top and only appears once */
    .dashboard-main > .navbar-header,
    main.dashboard-main > .navbar-header {
      position: relative !important;
      top: 0 !important;
      z-index: 1000 !important;
      order: 0 !important;
      flex-shrink: 0 !important;
      width: 100% !important;
      margin-left: 0 !important;
      margin-inline-start: 0 !important;
      margin-bottom: 0 !important;
      margin-top: 0 !important;
      padding-left: 1.5rem !important;
      padding-right: 1.5rem !important;
      box-sizing: border-box !important;
      background-color: var(--white) !important;
      display: block !important;
    }
    
    /* Prevent any duplicate topbar or search elements */
    .dashboard-main-body .navbar-header,
    .dashboard-main-body .navbar-search,
    .dashboard-main-body form.navbar-search {
      display: none !important;
    }
    
    /* Ensure only one topbar exists */
    .dashboard-main > .navbar-header:first-of-type,
    main.dashboard-main > .navbar-header:first-of-type {
      display: block !important;
    }
    
    .dashboard-main > .navbar-header:not(:first-of-type),
    main.dashboard-main > .navbar-header:not(:first-of-type) {
      display: none !important;
    }
    
    .dashboard-main-body {
      flex: 1 1 auto !important;
      order: 1 !important;
      overflow-y: visible !important;
      overflow-x: hidden !important;
      width: 100% !important;
      max-width: 100% !important;
      padding: 1.5rem !important;
      margin: 0 !important;
      margin-left: 0 !important;
      margin-inline-start: 0 !important;
      box-sizing: border-box !important;
      position: relative !important;
    }
    
    /* Ensure content inside dashboard-main-body doesn't overflow */
    .dashboard-main-body > * {
      max-width: 100% !important;
      box-sizing: border-box !important;
    }
    
    /* Ensure breadcrumb and content are visible */
    .dashboard-main-body .breadcrumb {
      display: flex !important;
      visibility: visible !important;
      opacity: 1 !important;
      position: relative !important;
      margin-top: 0 !important;
      margin-bottom: 1.5rem !important;
      width: 100% !important;
      max-width: 100% !important;
    }
    
    /* Ensure all content in dashboard-main-body is visible */
    .dashboard-main-body {
      padding-top: 1.5rem !important;
    }
    
    /* Prevent any negative margins or positioning that could hide content */
    .dashboard-main-body > *:first-child {
      margin-top: 0 !important;
      padding-top: 0 !important;
    }
    
    /* Fix for any container-fluid or container classes */
    .dashboard-main-body .container,
    .dashboard-main-body .container-fluid {
      padding-left: 1rem !important;
      padding-right: 1rem !important;
      max-width: 100% !important;
    }
  </style>
</head>

<body>
  <!-- Theme Customization Structure Start -->
  <div class="body-overlay"></div>

  <button type="button"
    class="theme-customization__button w-48-px h-48-px bg-primary-600 text-white rounded-circle d-flex justify-content-center align-items-center position-fixed end-0 bottom-0 mb-40 me-40 text-2xxl bg-hover-primary-700" aria-label="Theme Customization Button">
    <i class="ri-settings-3-line animate-spin"></i>
  </button>
  <div class="theme-customization-sidebar w-100 bg-base h-100vh overflow-y-auto position-fixed end-0 top-0">
    <div class="d-flex align-items-center gap-3 py-16 px-24 justify-content-between border-bottom">
      <div>
        <h6 class="text-sm dark:text-white">Theme Settings</h6>
        <p class="text-xs mb-0 text-neutral-500 dark:text-neutral-200">Customize and preview instantly</p>
      </div>
      <button data-slot="button"
        class="theme-customization-sidebar__close text-neutral-900 bg-transparent text-hover-primary-600 d-flex text-xl">
        <i class="ri-close-fill"></i>
      </button>
    </div>
    <div class="d-flex flex-column gap-48 p-24 overflow-y-auto flex-grow-1">
      <div class="theme-setting-item">
        <h6 class="fw-medium text-primary-light text-md mb-3">Theme Mode</h6>
        <div class="d-grid grid-cols-3 gap-3 dark-light-mode">
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl active"
            data-theme="light" aria-label="light">
            <i class="ri-sun-line"></i>
          </button>
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl"
            data-theme="dark" aria-label="dark">
            <i class="ri-moon-line"></i>
          </button>
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl"
            data-theme="system" aria-label="system">
            <i class="ri-computer-line"></i>
          </button>
        </div>
      </div>
      <div class="theme-setting-item">
        <h6 class="fw-medium text-primary-light text-md mb-3">Color Schema</h6>
        <div class="d-grid grid-cols-3 gap-3">
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="base" aria-label="Base">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #25A194;"></span>
            <span class="fw-medium mt-1" style="color: #25A194;">Base</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="red" aria-label="Red">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #dc2626;"></span>
            <span class="fw-medium mt-1" style="color: #dc2626;">Red</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="blue" aria-label="Blue">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #2563eb;"></span>
            <span class="fw-medium mt-1" style="color: #2563eb;">Blue</span>
          </button>
        </div>
      </div>
    </div>
  </div>
  <!-- Theme Customization Structure End -->

  <div class="overlay bg-black bg-opacity-50 w-100 h-100 position-fixed z-9 visibility-hidden opacity-0 duration-300">
  </div>

  @include('partials.admin.sidebar')

  <main class="dashboard-main">
    @include('partials.admin.topbar')

    <div class="dashboard-main-body">
      @yield('content')
    </div>
  </main>

  <!-- jQuery library js -->
  <script src="{{ asset('assets/js/lib/jquery-3.7.1.min.js') }}"></script>
  <!-- Bootstrap js -->
  <script src="{{ asset('assets/js/lib/bootstrap.bundle.min.js') }}"></script>
  <!-- Apex Chart js -->
  <script src="{{ asset('assets/js/lib/apexcharts.min.js') }}"></script>
  <!-- Iconify Font js -->
  <script src="{{ asset('assets/js/lib/iconify-icon.min.js') }}"></script>
  <!-- Data Table js -->
  <script src="{{ asset('assets/js/lib/dataTables.min.js') }}"></script>
  <!-- jQuery UI js -->
  <script src="{{ asset('assets/js/lib/jquery-ui.min.js') }}"></script>
  <!-- main js -->
  <script src="{{ asset('assets/js/app.js') }}"></script>
  @yield('scripts')

</body>

</html>
