@php
    $settings = \App\Models\Setting::first();
    $siteName = $settings->site_name ?? 'Tuition Management System';
    $logo = $settings && $settings->logo ? asset('storage/'.$settings->logo) : asset('assets/images/logo.png');
    $loginImage = $settings && $settings->login_image ? asset('storage/'.$settings->login_image) : asset('assets/images/thumbs/login-img.png');
    $favicon = $settings && $settings->logo_icon ? asset('storage/'.$settings->logo_icon) : asset('assets/images/favicon.png');
@endphp
<!DOCTYPE html>
<html lang="en" data-theme="light">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description"
    content="{{ $siteName }} - Admin, Teacher, and Parent Portal">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - {{ $siteName }}</title>
  <link rel="icon" type="image/png" href="{{ $favicon }}" sizes="16x16">
  <!-- remix icon font css  -->
  <link rel="stylesheet" href="{{ asset('assets/css/remixicon.css') }}">
  <!-- BootStrap css -->
  <link rel="stylesheet" href="{{ asset('assets/css/lib/bootstrap.min.css') }}">
  <!-- main css -->
  <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
</head>

<body>
  <!-- Theme Customization Structure Start -->
  <div class="body-overlay"></div>

  <button type="button"
    class="theme-customization__button w-48-px h-48-px bg-primary-600 text-white rounded-circle d-flex justify-content-center align-items-center position-fixed end-0 bottom-0 mb-40 me-40 text-2xxl bg-hover-primary-700" aria-label="Theme Customization Button">
    <i class="ri-settings-3-line animate-spin"></i>
  </button>
  <div class="theme-customization-sidebar w-100 bg-base h-100vh overflow-y-auto position-fixed end-0 top-0">
    <div class="d-flex align-items-center gap-3 py-16 px-24 justify-content-between border-bottom">
      <div>
        <h6 class="text-sm dark:text-white">Theme Settings</h6>
        <p class="text-xs mb-0 text-neutral-500 dark:text-neutral-200">Customize and preview instantly</p>
      </div>
      <button data-slot="button"
        class="theme-customization-sidebar__close text-neutral-900 bg-transparent text-hover-primary-600 d-flex text-xl">
        <i class="ri-close-fill"></i>
      </button>
    </div>

    <div class="d-flex flex-column gap-48 p-24 overflow-y-auto flex-grow-1">
      <div class="theme-setting-item">
        <h6 class="fw-medium text-primary-light text-md mb-3">Theme Mode</h6>
        <div class="d-grid grid-cols-3 gap-3 dark-light-mode">
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl active"
            data-theme="light" aria-label="light">
            <i class="ri-sun-line"></i>
          </button>
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl"
            data-theme="dark" aria-label="dark">
            <i class="ri-moon-line"></i>
          </button>
          <button type="button"
            class="theme-btn theme-setting-item__btn d-flex align-items-center justify-content-center h-64-px rounded-3 text-xl"
            data-theme="system" aria-label="system">
            <i class="ri-computer-line"></i>
          </button>
        </div>
      </div>

      <div class="theme-setting-item">
        <h6 class="fw-medium text-primary-light text-md mb-3">Color Schema</h6>
        <div class="d-grid grid-cols-3 gap-3">
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="base" aria-label="Base">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #25A194;"></span>
            <span class="fw-medium mt-1" style="color: #25A194;">Base</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="red" aria-label="Red">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #dc2626;"></span>
            <span class="fw-medium mt-1" style="color: #dc2626;">Red</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="blue" aria-label="Blue">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #2563eb;"></span>
            <span class="fw-medium mt-1" style="color: #2563eb;">Blue</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="yellow" aria-label="Yellow">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #ff9f29;"></span>
            <span class="fw-medium mt-1" style="color: #ff9f29;">Yellow</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="cyan" aria-label="Cyan">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #00b8f2;"></span>
            <span class="fw-medium mt-1" style="color: #00b8f2;">Cyan</span>
          </button>
          <button type="button"
            class="color-picker-btn d-flex flex-column justify-content-center align-items-center"
            data-color="violet" aria-label="Violet">
            <span class="color-picker-btn__box h-40-px w-100 rounded-3"
              style="background-color: #7c3aed;"></span>
            <span class="fw-medium mt-1" style="color: #7c3aed;">Violet</span>
          </button>
        </div>
      </div>
    </div>
  </div>
  <!-- Theme Customization Structure End -->

  <div class="overlay bg-black bg-opacity-50 w-100 h-100 position-fixed z-9 visibility-hidden opacity-0 duration-300">
  </div>

  <div class="d-lg-flex bg-white">
    <div class="w-50 d-lg-flex d-none overflow-hidden">
      <img src="{{ $loginImage }}" alt="Login Image" class="w-100 h-100 object-fit-cover">
    </div>
    <div class="lg-w-50 px-24 py-32 d-flex justify-content-center align-items-center">
      <div class="max-w-540-px mx-auto">
        <a href="{{ route('login') }}" class="">
          <img src="{{ $logo }}" alt="{{ $siteName }}" style="max-height: 120px; max-width: 240px;">
        </a>
        <div class="mt-32 mb-32">
          <h1 class="h6 fw-bold text-primary-light mb-8">
            @if(request()->routeIs('parent.login'))
              Parent Login
            @elseif(request()->routeIs('teacher.login'))
              Teacher Login
            @else
              Welcome Back 👋
            @endif
          </h1>
          <p class="text-sm text-secondary-light mb-0">
            @if(request()->routeIs('parent.login'))
              Use the email and password provided by the school to access your child's details.
            @elseif(request()->routeIs('teacher.login'))
              Use your teacher account email and password to access your dashboard.
            @else
              Log in to your account to continue
            @endif
          </p>
        </div>
        
        @if (isset($errors) && $errors->any())
          <div class="alert alert-danger">
            <ul class="mb-0">
              @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
        @endif

        <form action="{{ route('login') }}" method="POST" class="d-flex flex-column gap-32 submit-form">
          @csrf
          <div class="d-flex flex-column gap-16">
            <div>
              <label for="email" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                Email Address
                <span class="text-danger-600">*</span>
              </label>
              <input type="email" id="email" name="email" class="email-field form-control @error('email') is-invalid @enderror" 
                placeholder="Enter your email" value="{{ old('email', '') }}" required>
            </div>

            <div>
              <label for="password" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                Password
                <span class="text-danger-600">*</span>
              </label>
              <div class="position-relative">
                <input type="password" id="password" name="password" 
                  class="password-field form-control @error('password') is-invalid @enderror" 
                  placeholder="Enter your password" required>
                <button type="button"
                  class="toggle-password btn p-0 border-0 bg-transparent position-absolute end-0 top-50 translate-middle-y me-16 text-secondary-light cursor-pointer ri-eye-line"
                  data-toggle="#password" aria-label="Toggle password visibility">
                </button>
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-between gap-2">
            <div class="form-check style-check d-flex align-items-center">
              <input class="form-check-input border border-neutral-400" type="checkbox" value="1" id="remember" name="remember">
              <label class="form-check-label" for="remember">Remember me</label>
            </div>
            <a href="javascript:void(0)" class="text-primary-600 fw-medium text-decoration-underline">Forgot Password?</a>
          </div>
          <div class="">
            <button type="submit" class="loginBtn btn btn-primary-600 text-sm btn-sm px-12 py-16 w-100 radius-8">
              Log In
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- jQuery library js -->
  <script src="{{ asset('assets/js/lib/jquery-3.7.1.min.js') }}"></script>
  <!-- Bootstrap js -->
  <script src="{{ asset('assets/js/lib/bootstrap.bundle.min.js') }}"></script>
  <!-- main js -->
  <script src="{{ asset('assets/js/app.js') }}"></script>

</body>

</html>
