@extends('layouts.admin')

@section('title', 'Add New Teacher')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Add New Teacher</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.teacher.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Teacher</a>
            <span class="text-secondary-light">/ Add New Teacher</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.teacher.store') }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    <div class="row gy-3">
        <!-- Personal Info -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Personal Info</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Teacher ID
                                </label>
                                <input type="text" class="form-control bg-light" 
                                    value="Auto-generated (e.g., TCH-2026-0001)" readonly disabled>
                                <small class="text-secondary-light">Teacher ID will be auto-generated when you save</small>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Full Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="Enter your Full Name" 
                                    value="{{ old('name') }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Subjects
                                </label>
                                <div class="d-flex align-items-center gap-8">
                                    <button type="button" class="btn btn-outline-primary-600 text-sm" data-bs-toggle="modal" data-bs-target="#subjectModal">
                                        Select Subjects
                                    </button>
                                    <div id="selected-subjects-summary" class="text-sm text-secondary-light">
                                        No subjects selected
                                    </div>
                                </div>
                                <div id="subjects-hidden-container">
                                    @if(is_array(old('subjects')))
                                        @foreach(old('subjects', []) as $subjectId)
                                            <input type="hidden" name="subjects[]" value="{{ $subjectId }}">
                                        @endforeach
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="gender" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Gender</label>
                                <select id="gender" name="gender" class="form-control form-select">
                                    <option value="">Select Gender</option>
                                    <option value="Male" {{ old('gender') == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ old('gender') == 'Female' ? 'selected' : '' }}>Female</option>
                                    <option value="Other" {{ old('gender') == 'Other' ? 'selected' : '' }}>Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="date_of_birth" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Date Of Birth
                                </label>
                                <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" 
                                    value="{{ old('date_of_birth') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="father_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Fathers Name</label>
                                <input type="text" class="form-control" id="father_name" name="father_name" 
                                    placeholder="Enter Fathers Name" value="{{ old('father_name') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="mother_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Mothers Name</label>
                                <input type="text" class="form-control" id="mother_name" name="mother_name" 
                                    placeholder="Enter Mothers Name" value="{{ old('mother_name') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="marital_status" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Marital Status</label>
                                <select id="marital_status" name="marital_status" class="form-control form-select">
                                    <option value="">Select a Marital Status</option>
                                    <option value="Married" {{ old('marital_status') == 'Married' ? 'selected' : '' }}>Married</option>
                                    <option value="Unmarried" {{ old('marital_status') == 'Unmarried' ? 'selected' : '' }}>Unmarried</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="contract_type" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Contract Type</label>
                                <select id="contract_type" name="contract_type" class="form-control form-select">
                                    <option value="">Select a Contract Type</option>
                                    <option value="Contractual" {{ old('contract_type') == 'Contractual' ? 'selected' : '' }}>Contractual</option>
                                    <option value="Hourly" {{ old('contract_type') == 'Hourly' ? 'selected' : '' }}>Hourly</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="shift" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Shift</label>
                                <select id="shift" name="shift" class="form-control form-select">
                                    <option value="">Select a shift</option>
                                    <option value="Day Shift" {{ old('shift') == 'Day Shift' ? 'selected' : '' }}>Day Shift</option>
                                    <option value="Night Shift" {{ old('shift') == 'Night Shift' ? 'selected' : '' }}>Night Shift</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="work_location" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Work Location</label>
                                <input type="text" class="form-control" id="work_location" name="work_location" 
                                    placeholder="Enter work location" value="{{ old('work_location') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="join_date" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Join Date</label>
                                <input type="date" class="form-control" id="join_date" name="join_date" 
                                    value="{{ old('join_date') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Phone Number <span class="text-danger-600">*</span>
                                </label>
                                <input type="tel" class="form-control @error('phone') is-invalid @enderror" 
                                    id="phone" name="phone" placeholder="Enter your Phone Number" 
                                    value="{{ old('phone') }}" required>
                                @error('phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="email" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Email <span class="text-danger-600">*</span>
                                </label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                    id="email" name="email" placeholder="Enter your Email" 
                                    value="{{ old('email') }}" required>
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="password" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Password <span class="text-danger-600">*</span>
                                </label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror" 
                                    id="password" name="password" placeholder="Enter Password (min 6 characters)" 
                                    minlength="6" required>
                                @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">This will be used for teacher login</small>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="experience" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Experience</label>
                                <input type="text" class="form-control" id="experience" name="experience" 
                                    placeholder="Enter experience" value="{{ old('experience') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="qualification" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Qualification</label>
                                <input type="text" class="form-control" id="qualification" name="qualification" 
                                    placeholder="Enter Qualification" value="{{ old('qualification') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="photo" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Teacher Photo</label>
                                <input type="file" class="form-control @error('photo') is-invalid @enderror" 
                                    id="photo" name="photo" accept="image/*">
                                @error('photo')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Subject Selection Modal -->
        <div class="modal fade" id="subjectModal" tabindex="-1" aria-labelledby="subjectModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-scrollable modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="subjectModalLabel">Select Subjects</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <input type="text" id="subjectSearch" class="form-control" placeholder="Search subjects...">
                        </div>
                        <div class="max-h-300-px overflow-y-auto">
                            @if(isset($subjects) && $subjects->count())
                                @foreach($subjects as $subject)
                                <div class="form-check subject-item mb-2" data-name="{{ strtolower($subject->name) }}">
                                    <input class="form-check-input subject-checkbox" type="checkbox"
                                        value="{{ $subject->id }}" id="modal_subject_{{ $subject->id }}"
                                        data-label="{{ $subject->name }}">
                                    <label class="form-check-label" for="modal_subject_{{ $subject->id }}">
                                        {{ $subject->name }}
                                    </label>
                                </div>
                                @endforeach
                            @else
                                <p class="text-secondary-light mb-0">No subjects found. Please add subjects first.</p>
                            @endif
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-primary-600" data-bs-dismiss="modal">Apply</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Medical Details -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Medical Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="blood_group" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Blood Group</label>
                                <select id="blood_group" name="blood_group" class="form-control form-select">
                                    <option value="">Select blood group</option>
                                    <option value="A+" {{ old('blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                                    <option value="A-" {{ old('blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                                    <option value="B+" {{ old('blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                                    <option value="B-" {{ old('blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                                    <option value="AB+" {{ old('blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                                    <option value="AB-" {{ old('blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                                    <option value="O+" {{ old('blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                                    <option value="O-" {{ old('blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="height" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Height</label>
                                <input type="text" class="form-control" id="height" name="height" 
                                    placeholder="Enter height" value="{{ old('height') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="weight" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Weight</label>
                                <input type="text" class="form-control" id="weight" name="weight" 
                                    placeholder="Enter Weight" value="{{ old('weight') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bank Details -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Bank Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="bank_account_number" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Bank Account Number</label>
                                <input type="text" class="form-control" id="bank_account_number" name="bank_account_number" 
                                    placeholder="Enter bank account number" value="{{ old('bank_account_number') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="bank_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Bank Name</label>
                                <input type="text" class="form-control" id="bank_name" name="bank_name" 
                                    placeholder="Enter bank name" value="{{ old('bank_name') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="ifsc_code" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">IFSC Code</label>
                                <input type="text" class="form-control" id="ifsc_code" name="ifsc_code" 
                                    placeholder="Enter IFSC Code" value="{{ old('ifsc_code') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="national_identification_number" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">National Identification Number</label>
                                <input type="text" class="form-control" id="national_identification_number" name="national_identification_number" 
                                    placeholder="Enter national identification number" value="{{ old('national_identification_number') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Previous School Details -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Previous School Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-6 col-xl-6 col-sm-12">
                            <div class="">
                                <label for="previous_school_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">School Name</label>
                                <input type="text" class="form-control" id="previous_school_name" name="previous_school_name" 
                                    placeholder="Enter School Name" value="{{ old('previous_school_name') }}">
                            </div>
                        </div>
                        <div class="col-xxl-6 col-xl-6 col-sm-12">
                            <div class="">
                                <label for="previous_school_address" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">School Address</label>
                                <input type="text" class="form-control" id="previous_school_address" name="previous_school_address" 
                                    placeholder="Enter School Address" value="{{ old('previous_school_address') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Upload Documents -->
        <div class="col-xxl-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Upload Documents</h6>
                </div>
                <div class="card-body p-20">
                    <div id="documents-container">
                        <div class="row gy-3 document-row">
                            <div class="col-sm-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Doc Name</label>
                                    <input type="text" class="form-control" name="documents[0][name]" 
                                        placeholder="Enter Doc Name (e.g., Resume, Certificate)">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="">
                                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Upload File</label>
                                    <input type="file" class="form-control" name="documents[0][file]" 
                                        accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                    <small class="text-secondary-light">PDF, DOC, DOCX, JPG, PNG (Max 5MB)</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-primary-600 mt-3" id="add-document-btn">
                        <i class="ri-add-line"></i> Add Another Document
                    </button>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.teacher.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let documentCount = 1;
        
        document.getElementById('add-document-btn').addEventListener('click', function() {
            const container = document.getElementById('documents-container');
            const newRow = document.createElement('div');
            newRow.className = 'row gy-3 document-row mt-3';
            newRow.innerHTML = `
                <div class="col-sm-6">
                    <div class="">
                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Doc Name</label>
                        <input type="text" class="form-control" name="documents[${documentCount}][name]" 
                            placeholder="Enter Doc Name (e.g., Resume, Certificate)">
                    </div>
                </div>
                <div class="col-sm-5">
                    <div class="">
                        <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Upload File</label>
                        <input type="file" class="form-control" name="documents[${documentCount}][file]" 
                            accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        <small class="text-secondary-light">PDF, DOC, DOCX, JPG, PNG (Max 5MB)</small>
                    </div>
                </div>
                <div class="col-sm-1">
                    <div class="d-flex align-items-end h-100">
                        <button type="button" class="btn btn-danger-600 btn-sm remove-document-btn" style="margin-top: 28px;">
                            <i class="ri-delete-bin-6-line"></i>
                        </button>
                    </div>
                </div>
            `;
            container.appendChild(newRow);
            documentCount++;
            
            // Add remove functionality
            newRow.querySelector('.remove-document-btn').addEventListener('click', function() {
                newRow.remove();
            });
        });
        
        // Add remove functionality to existing remove buttons (if any)
        document.querySelectorAll('.remove-document-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                this.closest('.document-row').remove();
            });
        });

        // Subject modal logic
        const selectedSubjects = new Set(@json(old('subjects', [])));
        const hiddenContainer = document.getElementById('subjects-hidden-container');
        const summaryEl = document.getElementById('selected-subjects-summary');
        const checkboxes = document.querySelectorAll('.subject-checkbox');

        function syncSubjectsUI() {
            if (!hiddenContainer) return;

            hiddenContainer.innerHTML = '';
            const names = [];

            checkboxes.forEach(cb => {
                const id = cb.value;
                if (selectedSubjects.has(id) || selectedSubjects.has(Number(id))) {
                    cb.checked = true;
                    const input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = 'subjects[]';
                    input.value = id;
                    hiddenContainer.appendChild(input);
                    names.push(cb.dataset.label);
                } else {
                    cb.checked = false;
                }
            });

            if (summaryEl) {
                summaryEl.textContent = names.length ? names.join(', ') : 'No subjects selected';
            }
        }

        checkboxes.forEach(cb => {
            cb.addEventListener('change', function() {
                const id = this.value;
                if (this.checked) {
                    selectedSubjects.add(id);
                } else {
                    selectedSubjects.delete(id);
                }
                syncSubjectsUI();
            });
        });

        const searchInput = document.getElementById('subjectSearch');
        if (searchInput) {
            searchInput.addEventListener('input', function() {
                const term = this.value.toLowerCase();
                document.querySelectorAll('.subject-item').forEach(item => {
                    const name = item.dataset.name || '';
                    item.style.display = name.includes(term) ? '' : 'none';
                });
            });
        }

        syncSubjectsUI();
    });
</script>
@endsection

