@extends('layouts.admin')

@section('title', 'Student Details')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Student Details</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.student.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Student</a>
            <span class="text-secondary-light">/ Student Details</span>
        </div>
    </div>
    <a href="{{ route('admin.student.edit', $student->id) }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-edit-2-line"></i>
        </span>
        Edit Student
    </a>
</div>

<div class="row gy-3">
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Student Information</h6>
            </div>
            <div class="card-body p-20">
                <div class="row gy-3">
                    <div class="col-md-3">
                        <div class="text-center mb-3">
                            @if($student->photo)
                            <img src="{{ asset('storage/' . $student->photo) }}" alt="{{ $student->name }}" 
                                class="w-120-px h-120-px rounded-circle object-fit-cover">
                            @else
                            <div class="w-120-px h-120-px rounded-circle bg-primary-100 d-flex align-items-center justify-content-center mx-auto">
                                <span class="text-primary-600 fw-bold text-3xl">{{ substr($student->name, 0, 1) }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <strong>Admission No:</strong> {{ $student->admission_no }}
                            </div>
                            <div class="col-md-6">
                                <strong>Name:</strong> {{ $student->name }}
                            </div>
                            <div class="col-md-6">
                                <strong>Email:</strong> {{ $student->email ?: 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Phone:</strong> {{ $student->phone ?: 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Date of Birth:</strong> {{ $student->date_of_birth ? $student->date_of_birth->format('d M Y') : 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Gender:</strong> {{ $student->gender ?: 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Academic Year:</strong> {{ $student->academicYear ? $student->academicYear->name : 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Class:</strong> {{ $student->schoolClass ? $student->schoolClass->name : 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Section:</strong> {{ $student->section ? $student->section->name : 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Batch:</strong> {{ $student->batch ? $student->batch->name : 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Roll Number:</strong> {{ $student->roll_number ?: 'N/A' }}
                            </div>
                            <div class="col-md-6">
                                <strong>Status:</strong> 
                                <span class="bg-{{ $student->is_active ? 'success' : 'danger' }}-100 text-{{ $student->is_active ? 'success' : 'danger' }}-600 px-24 py-4 radius-4 fw-medium text-sm">
                                    {{ $student->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Parent & Guardian Information</h6>
            </div>
            <div class="card-body p-20">
                <div class="row gy-3">
                    @if($student->parent)
                    <div class="col-md-12 mb-3">
                        <strong>Linked Parent User:</strong> 
                        <a href="#">{{ $student->parent->name }} ({{ $student->parent->email }})</a>
                    </div>
                    @endif
                    <div class="col-md-4">
                        <h6 class="fw-semibold mb-3">Father's Information</h6>
                        <p><strong>Name:</strong> {{ $student->father_name ?: 'N/A' }}</p>
                        <p><strong>Phone:</strong> {{ $student->father_phone ?: 'N/A' }}</p>
                        <p><strong>Occupation:</strong> {{ $student->father_occupation ?: 'N/A' }}</p>
                    </div>
                    <div class="col-md-4">
                        <h6 class="fw-semibold mb-3">Mother's Information</h6>
                        <p><strong>Name:</strong> {{ $student->mother_name ?: 'N/A' }}</p>
                        <p><strong>Phone:</strong> {{ $student->mother_phone ?: 'N/A' }}</p>
                        <p><strong>Occupation:</strong> {{ $student->mother_occupation ?: 'N/A' }}</p>
                    </div>
                    <div class="col-md-4">
                        <h6 class="fw-semibold mb-3">Guardian Information</h6>
                        <p><strong>Name:</strong> {{ $student->guardian_name ?: 'N/A' }}</p>
                        <p><strong>Phone:</strong> {{ $student->guardian_phone ?: 'N/A' }}</p>
                        <p><strong>Relation:</strong> {{ $student->guardian_relation ?: 'N/A' }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">Address</h6>
            </div>
            <div class="card-body p-20">
                <p><strong>Address:</strong> {{ $student->address ?: 'N/A' }}</p>
                <div class="row">
                    <div class="col-md-3"><strong>City:</strong> {{ $student->city ?: 'N/A' }}</div>
                    <div class="col-md-3"><strong>State:</strong> {{ $student->state ?: 'N/A' }}</div>
                    <div class="col-md-3"><strong>Zip Code:</strong> {{ $student->zip_code ?: 'N/A' }}</div>
                    <div class="col-md-3"><strong>Country:</strong> {{ $student->country ?: 'N/A' }}</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


