@extends('layouts.admin')

@section('title', 'Student List')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Student List</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Student List</span>
        </div>
    </div>
    <a href="{{ route('admin.student.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Add Student
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-0 dataTable-wrapper">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
                <div class="d-flex flex-wrap align-items-center gap-16">
                    <form class="navbar-search dt-search m-0">
                        <input type="text" class="dt-input bg-transparent radius-4" aria-controls="dataTable"
                            name="search" placeholder="Search...">
                        <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>
                    </form>
                </div>
            </div>

            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='10'>
                    <thead>
                        <tr>
                            <th scope="col">S.L</th>
                            <th scope="col">Admission No</th>
                            <th scope="col">Name</th>
                            <th scope="col">Class</th>
                            <th scope="col">Section</th>
                            <th scope="col">Parent</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($students as $index => $student)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $student->admission_no }}</td>
                            <td>
                                <div class="d-flex align-items-center gap-2">
                                    @if($student->photo)
                                    <img src="{{ asset('storage/' . $student->photo) }}" alt="{{ $student->name }}" 
                                        class="w-40-px h-40-px rounded-circle object-fit-cover">
                                    @else
                                    <div class="w-40-px h-40-px rounded-circle bg-primary-100 d-flex align-items-center justify-content-center">
                                        <span class="text-primary-600 fw-bold">{{ substr($student->name, 0, 1) }}</span>
                                    </div>
                                    @endif
                                    <span>{{ $student->name }}</span>
                                </div>
                            </td>
                            <td>{{ $student->schoolClass ? $student->schoolClass->name : 'N/A' }}</td>
                            <td>{{ $student->section ? $student->section->name : 'N/A' }}</td>
                            <td>{{ $student->parent ? $student->parent->name : ($student->father_name ?: 'N/A') }}</td>
                            <td>
                                <span class="bg-{{ $student->is_active ? 'success' : 'danger' }}-100 text-{{ $student->is_active ? 'success' : 'danger' }}-600 px-24 py-4 radius-4 fw-medium text-sm">
                                    {{ $student->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <button type="button" class="text-primary-light text-xl"
                                        data-bs-toggle="dropdown" data-bs-display="static"
                                        aria-expanded="false">
                                        <iconify-icon icon="tabler:dots-vertical"></iconify-icon>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-lg-end border p-12">
                                        <li>
                                            <a href="{{ route('admin.student.show', $student->id) }}"
                                                class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
                                                <i class="ri-eye-line"></i>
                                                View
                                            </a>
                                        </li>
                                        <li>
                                            <a href="{{ route('admin.student.edit', $student->id) }}"
                                                class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
                                                <i class="ri-edit-2-line"></i>
                                                Edit
                                            </a>
                                        </li>
                                        <li>
                                            <form action="{{ route('admin.student.destroy', $student->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                    class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6"
                                                    onclick="return confirm('Are you sure you want to delete this student?')">
                                                    <i class="ri-delete-bin-6-line"></i>
                                                    Delete
                                                </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">No students found. <a href="{{ route('admin.student.create') }}">Add one</a>.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection


