@extends('layouts.admin')

@section('title', 'Edit Student')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Student</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.student.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Student</a>
            <span class="text-secondary-light">/ Edit Student</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.student.update', $student->id) }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <!-- Personal Info -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Personal Info</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="academic_year_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Academic Year <span class="text-danger-600">*</span>
                                </label>
                                <select id="academic_year_id" name="academic_year_id" class="form-control form-select @error('academic_year_id') is-invalid @enderror" required>
                                    <option value="">Select Academic Year</option>
                                    @foreach($academicYears as $year)
                                    <option value="{{ $year->id }}" {{ old('academic_year_id', $student->academic_year_id) == $year->id ? 'selected' : '' }}>
                                        {{ $year->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('academic_year_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="class_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Class <span class="text-danger-600">*</span>
                                </label>
                                <select id="class_id" name="class_id" class="form-control form-select @error('class_id') is-invalid @enderror" required>
                                    <option value="">Select Class</option>
                                    @foreach($classes as $class)
                                    <option value="{{ $class->id }}" {{ old('class_id', $student->class_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('class_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="section_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Section <span class="text-danger-600">*</span>
                                </label>
                                <select id="section_id" name="section_id" class="form-control form-select @error('section_id') is-invalid @enderror" required>
                                    <option value="">Select Section</option>
                                    @foreach($sections as $section)
                                    <option value="{{ $section->id }}" {{ old('section_id', $student->section_id) == $section->id ? 'selected' : '' }}>
                                        {{ $section->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('section_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="batch_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Batch
                                </label>
                                <select id="batch_id" name="batch_id" class="form-control form-select">
                                    <option value="">Select Batch</option>
                                    @foreach($batches as $batch)
                                    <option value="{{ $batch->id }}" {{ old('batch_id', $student->batch_id) == $batch->id ? 'selected' : '' }}>
                                        {{ $batch->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="admission_no" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Admission No
                                </label>
                                <input type="text" class="form-control bg-light" 
                                    id="admission_no" name="admission_no" 
                                    value="{{ $student->admission_no }}" readonly disabled>
                                <small class="text-secondary-light">Admission number cannot be changed</small>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Full Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="Enter Full Name" 
                                    value="{{ old('name', $student->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="roll_number" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Roll Number
                                </label>
                                <input type="text" class="form-control" id="roll_number" name="roll_number" 
                                    placeholder="Enter Roll Number" value="{{ old('roll_number', $student->roll_number) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="gender" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Gender
                                </label>
                                <select id="gender" name="gender" class="form-control form-select">
                                    <option value="">Select Gender</option>
                                    <option value="Male" {{ old('gender', $student->gender) == 'Male' ? 'selected' : '' }}>Male</option>
                                    <option value="Female" {{ old('gender', $student->gender) == 'Female' ? 'selected' : '' }}>Female</option>
                                    <option value="Other" {{ old('gender', $student->gender) == 'Other' ? 'selected' : '' }}>Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="date_of_birth" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Date Of Birth
                                </label>
                                <input type="date" class="form-control" id="date_of_birth" name="date_of_birth" 
                                    value="{{ old('date_of_birth', $student->date_of_birth ? $student->date_of_birth->format('Y-m-d') : '') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Phone Number
                                </label>
                                <input type="text" class="form-control" id="phone" name="phone" 
                                    placeholder="Enter Phone Number" value="{{ old('phone', $student->phone) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="email" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Email
                                </label>
                                <input type="email" class="form-control" id="email" name="email" 
                                    placeholder="Enter Email" value="{{ old('email', $student->email) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="photo" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Student Photo
                                </label>
                                @if($student->photo)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $student->photo) }}" alt="Current Photo" class="w-60-px h-60-px rounded">
                                </div>
                                @endif
                                <input type="file" class="form-control" id="photo" name="photo" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Parent & Guardian Info -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Parent & Guardian Info</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        @if($student->parent)
                        <div class="col-12 mb-3">
                            <div class="alert alert-success">
                                <strong>Current Parent:</strong> {{ $student->parent->name }} ({{ $student->parent->email }})
                            </div>
                        </div>
                        @endif
                        <div class="col-12 mb-3">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Link to Existing Parent User
                            </label>
                            <select id="parent_id" name="parent_id" class="form-control form-select">
                                <option value="">Select Parent (Optional)</option>
                                @foreach($parents as $parent)
                                <option value="{{ $parent->id }}" {{ old('parent_id', $student->parent_id) == $parent->id ? 'selected' : '' }}>
                                    {{ $parent->name }} ({{ $parent->email }})
                                </option>
                                @endforeach
                            </select>
                            <small class="text-secondary-light">Or create new parent account below if not linked</small>
                        </div>
                        @if(!$student->parent)
                        <div class="col-12">
                            <h6 class="text-md fw-semibold mb-3 text-primary-light">Create New Parent Account (Optional)</h6>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="parent_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('parent_name') is-invalid @enderror" 
                                    id="parent_name" name="parent_name" 
                                    placeholder="Enter Parent Name" 
                                    value="{{ old('parent_name') }}">
                                @error('parent_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="parent_email" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Email <span class="text-danger-600">*</span>
                                </label>
                                <input type="email" class="form-control @error('parent_email') is-invalid @enderror" 
                                    id="parent_email" name="parent_email" 
                                    placeholder="Enter Parent Email" 
                                    value="{{ old('parent_email') }}">
                                @error('parent_email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="parent_password" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Password <span class="text-danger-600">*</span>
                                </label>
                                <div class="position-relative">
                                    <input type="password" class="form-control @error('parent_password') is-invalid @enderror" 
                                        id="parent_password" name="parent_password" 
                                        placeholder="Enter Password (min 6 characters)" 
                                        minlength="6">
                                    <span class="toggle-password ri-eye-line cursor-pointer position-absolute end-0 top-50 translate-middle-y me-16 text-secondary-light"
                                        data-toggle="#parent_password"></span>
                                </div>
                                @error('parent_password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        @endif
                        <div class="col-12">
                            <hr class="my-3">
                            <h6 class="text-md fw-semibold mb-3 text-primary-light">Parent Details (Father/Mother/Guardian)</h6>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="father_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Father's Name
                                </label>
                                <input type="text" class="form-control" id="father_name" name="father_name" 
                                    placeholder="Enter Father's Name" value="{{ old('father_name', $student->father_name) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="father_phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Father's Phone
                                </label>
                                <input type="text" class="form-control" id="father_phone" name="father_phone" 
                                    placeholder="Enter Father's Number" value="{{ old('father_phone', $student->father_phone) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="mother_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Mother's Name
                                </label>
                                <input type="text" class="form-control" id="mother_name" name="mother_name" 
                                    placeholder="Enter Mother's Name" value="{{ old('mother_name', $student->mother_name) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="mother_phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Mother's Phone
                                </label>
                                <input type="text" class="form-control" id="mother_phone" name="mother_phone" 
                                    placeholder="Enter Mother's Number" value="{{ old('mother_phone', $student->mother_phone) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="guardian_name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Guardian Name
                                </label>
                                <input type="text" class="form-control" id="guardian_name" name="guardian_name" 
                                    placeholder="Enter Guardian Name" value="{{ old('guardian_name', $student->guardian_name) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="guardian_phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Guardian Phone
                                </label>
                                <input type="text" class="form-control" id="guardian_phone" name="guardian_phone" 
                                    placeholder="Enter Guardian Number" value="{{ old('guardian_phone', $student->guardian_phone) }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Address -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Address</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-12">
                            <div class="">
                                <label for="address" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Address
                                </label>
                                <textarea class="form-control" id="address" name="address" rows="3" 
                                    placeholder="Enter Address">{{ old('address', $student->address) }}</textarea>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="city" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    City
                                </label>
                                <input type="text" class="form-control" id="city" name="city" 
                                    placeholder="Enter City" value="{{ old('city', $student->city) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="state" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    State
                                </label>
                                <input type="text" class="form-control" id="state" name="state" 
                                    placeholder="Enter State" value="{{ old('state', $student->state) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="zip_code" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Zip Code
                                </label>
                                <input type="text" class="form-control" id="zip_code" name="zip_code" 
                                    placeholder="Enter Zip Code" value="{{ old('zip_code', $student->zip_code) }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="is_active" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Status
                                </label>
                                <select id="is_active" name="is_active" class="form-control form-select">
                                    <option value="0" {{ old('is_active', $student->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                                    <option value="1" {{ old('is_active', $student->is_active) == '1' ? 'selected' : '' }}>Active</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.student.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

