@extends('layouts.admin')

@section('title', 'Branding Settings')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Branding Settings</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Branding</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.settings.branding.update') }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Branding</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-6 col-xl-6 col-sm-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Site Name <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="site_name" class="form-control" required
                                value="{{ old('site_name', $setting->site_name ?? 'Tuition Management System') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Logos</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-4">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Main Logo
                            </label>
                            <div class="mb-2">
                                @if(!empty($setting?->logo))
                                    <img src="{{ asset('storage/'.$setting->logo) }}" alt="Logo" style="height:40px;">
                                @else
                                    <img src="{{ asset('assets/images/logo.png') }}" alt="Logo" style="height:40px;">
                                @endif
                            </div>
                            <input type="file" name="logo" class="form-control" accept="image/*">
                            <small class="text-secondary-light d-block mt-1">Shown on light mode sidebar and login.</small>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Light Logo
                            </label>
                            <div class="mb-2">
                                @if(!empty($setting?->logo_light))
                                    <img src="{{ asset('storage/'.$setting->logo_light) }}" alt="Light Logo" style="height:40px;">
                                @else
                                    <img src="{{ asset('assets/images/logo-light.png') }}" alt="Light Logo" style="height:40px;">
                                @endif
                            </div>
                            <input type="file" name="logo_light" class="form-control" accept="image/*">
                            <small class="text-secondary-light d-block mt-1">Used for dark backgrounds.</small>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Icon Logo
                            </label>
                            <div class="mb-2">
                                @if(!empty($setting?->logo_icon))
                                    <img src="{{ asset('storage/'.$setting->logo_icon) }}" alt="Icon Logo" style="height:40px;">
                                @else
                                    <img src="{{ asset('assets/images/logo-icon.png') }}" alt="Icon Logo" style="height:40px;">
                                @endif
                            </div>
                            <input type="file" name="logo_icon" class="form-control" accept="image/*">
                            <small class="text-secondary-light d-block mt-1">Used in compact places (sidebar icon, browser tab).</small>
                        </div>
                        <div class="col-md-12 mt-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Login Page Image
                            </label>
                            <div class="mb-2">
                                @if(!empty($setting?->login_image))
                                    <img src="{{ asset('storage/'.$setting->login_image) }}" alt="Login Image" style="height:120px; border-radius: 8px;">
                                @else
                                    <img src="{{ asset('assets/images/thumbs/login-img.png') }}" alt="Login Image" style="height:120px; border-radius: 8px;">
                                @endif
                            </div>
                            <input type="file" name="login_image" class="form-control" accept="image/*">
                            <small class="text-secondary-light d-block mt-1">Displayed on the left side of the login page. Recommended size: 800x1000px</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Information Section -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Contact Information</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Contact Phone
                            </label>
                            <input type="text" name="contact_phone" class="form-control" placeholder="+91 1234567890"
                                value="{{ old('contact_phone', $setting->contact_phone ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Contact Email
                            </label>
                            <input type="email" name="contact_email" class="form-control" placeholder="support@example.com"
                                value="{{ old('contact_email', $setting->contact_email ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                WhatsApp Number
                            </label>
                            <input type="text" name="contact_whatsapp" class="form-control" placeholder="+91 1234567890"
                                value="{{ old('contact_whatsapp', $setting->contact_whatsapp ?? '') }}">
                            <small class="text-secondary-light">Include country code</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Address Section -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Address</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Street Address
                            </label>
                            <textarea name="address" class="form-control" rows="2" placeholder="Enter street address">{{ old('address', $setting->address ?? '') }}</textarea>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                City
                            </label>
                            <input type="text" name="city" class="form-control" placeholder="City"
                                value="{{ old('city', $setting->city ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                State
                            </label>
                            <input type="text" name="state" class="form-control" placeholder="State"
                                value="{{ old('state', $setting->state ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                ZIP Code
                            </label>
                            <input type="text" name="zip_code" class="form-control" placeholder="ZIP Code"
                                value="{{ old('zip_code', $setting->zip_code ?? '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Google Maps URL
                            </label>
                            <input type="url" name="map_url" class="form-control" placeholder="https://maps.google.com/..."
                                value="{{ old('map_url', $setting->map_url ?? '') }}">
                            <small class="text-secondary-light">Paste Google Maps link for directions</small>
                        </div>
                        <div class="col-md-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Office Hours
                            </label>
                            <input type="text" name="office_hours" class="form-control" placeholder="Mon-Sat: 9:00 AM - 6:00 PM"
                                value="{{ old('office_hours', $setting->office_hours ?? '') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Social Links Section -->
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden mt-3">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Social Links</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                <i class="ri-global-line me-1"></i> Website URL
                            </label>
                            <input type="url" name="website_url" class="form-control" placeholder="https://yourwebsite.com"
                                value="{{ old('website_url', $setting->website_url ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                <i class="ri-facebook-fill me-1"></i> Facebook URL
                            </label>
                            <input type="url" name="facebook_url" class="form-control" placeholder="https://facebook.com/yourpage"
                                value="{{ old('facebook_url', $setting->facebook_url ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                <i class="ri-instagram-line me-1"></i> Instagram URL
                            </label>
                            <input type="url" name="instagram_url" class="form-control" placeholder="https://instagram.com/yourpage"
                                value="{{ old('instagram_url', $setting->instagram_url ?? '') }}">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.dashboard') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Settings
                </button>
            </div>
        </div>
    </div>
</form>
@endsection



