@extends('layouts.admin')

@section('title', 'Edit Section')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Section</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.section.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Section</a>
            <span class="text-secondary-light">/ Edit Section</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.section.update', $section->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Section Information</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Section Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="e.g., A, B, Science, Art" 
                                    value="{{ old('name', $section->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="class_id" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Class
                                </label>
                                <select id="class_id" name="class_id" class="form-control form-select">
                                    <option value="">Select Class</option>
                                    @foreach($classes as $class)
                                    <option value="{{ $class->id }}" {{ old('class_id', $section->class_id) == $class->id ? 'selected' : '' }}>
                                        {{ $class->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="seats" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Total Seats <span class="text-danger-600">*</span>
                                </label>
                                <input type="number" class="form-control @error('seats') is-invalid @enderror" 
                                    id="seats" name="seats" placeholder="Enter total seats (e.g., 20)" 
                                    value="{{ old('seats', $section->seats ?? 20) }}" min="1" max="1000" required>
                                @error('seats')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">
                                    Maximum number of students allowed. Currently filled: {{ $section->filled_seats ?? 0 }} / {{ $section->seats ?? 20 }}
                                </small>
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="is_active" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Status
                                </label>
                                <select id="is_active" name="is_active" class="form-control form-select">
                                    <option value="0" {{ old('is_active', $section->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                                    <option value="1" {{ old('is_active', $section->is_active) == '1' ? 'selected' : '' }}>Active</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="">
                                <label for="description" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Description
                                </label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                    id="description" name="description" rows="3" 
                                    placeholder="Enter section description">{{ old('description', $section->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.section.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

