@extends('layouts.admin')
@use('Illuminate\Support\Facades\Storage')

@section('title', 'My Profile')

@section('content')
<div class="d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <h6 class="fw-semibold mb-0">My Profile</h6>
    <ul class="d-flex align-items-center gap-2">
        <li class="fw-medium">
            <a href="{{ route('admin.dashboard') }}" class="d-flex align-items-center gap-1 hover-text-primary">
                <iconify-icon icon="solar:home-smile-angle-outline" class="icon text-lg"></iconify-icon>
                Dashboard
            </a>
        </li>
        <li>-</li>
        <li class="fw-medium">My Profile</li>
    </ul>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="row gy-4">
    <!-- Profile Card -->
    <div class="col-lg-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <div class="mb-24">
                    @if($user->photo && Storage::disk('public')->exists($user->photo))
                        <img src="{{ asset('storage/' . $user->photo) }}" 
                             alt="{{ $user->name }}" 
                             class="w-120-px h-120-px rounded-circle object-fit-cover border border-4 border-primary-100">
                    @else
                        <div class="w-120-px h-120-px rounded-circle bg-primary-100 d-flex align-items-center justify-content-center mx-auto">
                            <span class="text-primary-600 text-4xl fw-bold">{{ strtoupper(substr($user->name, 0, 1)) }}</span>
                        </div>
                    @endif
                </div>
                <h5 class="mb-4">{{ $user->name }}</h5>
                <span class="badge bg-primary-100 text-primary-600 px-16 py-8 rounded-pill text-sm">{{ ucfirst($user->role) }}</span>
                
                <div class="mt-24">
                    <div class="d-flex align-items-center justify-content-center gap-8 mb-12">
                        <i class="ri-mail-line text-primary-600"></i>
                        <span class="text-secondary-light">{{ $user->email }}</span>
                    </div>
                    @if($user->phone)
                    <div class="d-flex align-items-center justify-content-center gap-8">
                        <i class="ri-phone-line text-primary-600"></i>
                        <span class="text-secondary-light">{{ $user->phone }}</span>
                    </div>
                    @endif
                </div>
                
                <div class="mt-24 pt-24 border-top">
                    <div class="row text-center">
                        <div class="col-6">
                            <h6 class="mb-4">Member Since</h6>
                            <span class="text-secondary-light text-sm">{{ $user->created_at->format('M d, Y') }}</span>
                        </div>
                        <div class="col-6">
                            <h6 class="mb-4">Last Login</h6>
                            <span class="text-secondary-light text-sm">{{ $user->updated_at->diffForHumans() }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Profile Form -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0">Edit Profile</h6>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.profile.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="row gy-3">
                        <div class="col-md-6">
                            <label class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email Address <span class="text-danger">*</span></label>
                            <input type="email" name="email" class="form-control" value="{{ old('email', $user->email) }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Phone Number</label>
                            <input type="text" name="phone" class="form-control" value="{{ old('phone', $user->phone) }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Profile Photo</label>
                            <input type="file" name="photo" class="form-control" accept="image/*">
                            @if($user->photo && Storage::disk('public')->exists($user->photo))
                                <small class="text-muted">Current photo will be replaced if new one is uploaded</small>
                            @endif
                        </div>
                    </div>
                    
                    <div class="mt-24">
                        <button type="submit" class="btn btn-primary-600">
                            <i class="ri-save-line me-1"></i> Update Profile
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Change Password Card -->
        <div class="card mt-24">
            <div class="card-header">
                <h6 class="mb-0">Change Password</h6>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.profile.password') }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row gy-3">
                        <div class="col-md-12">
                            <label class="form-label">Current Password <span class="text-danger">*</span></label>
                            <div class="position-relative">
                                <input type="password" name="current_password" class="form-control" required>
                                <span class="position-absolute top-50 translate-middle-y end-0 me-12 cursor-pointer toggle-password">
                                    <i class="ri-eye-line"></i>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">New Password <span class="text-danger">*</span></label>
                            <div class="position-relative">
                                <input type="password" name="password" class="form-control" required minlength="8">
                                <span class="position-absolute top-50 translate-middle-y end-0 me-12 cursor-pointer toggle-password">
                                    <i class="ri-eye-line"></i>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Confirm New Password <span class="text-danger">*</span></label>
                            <div class="position-relative">
                                <input type="password" name="password_confirmation" class="form-control" required>
                                <span class="position-absolute top-50 translate-middle-y end-0 me-12 cursor-pointer toggle-password">
                                    <i class="ri-eye-line"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-24">
                        <button type="submit" class="btn btn-warning-600">
                            <i class="ri-lock-password-line me-1"></i> Change Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    // Toggle password visibility
    document.querySelectorAll('.toggle-password').forEach(function(el) {
        el.addEventListener('click', function() {
            const input = this.previousElementSibling;
            const icon = this.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('ri-eye-line');
                icon.classList.add('ri-eye-off-line');
            } else {
                input.type = 'password';
                icon.classList.remove('ri-eye-off-line');
                icon.classList.add('ri-eye-line');
            }
        });
    });
</script>
@endpush
@endsection
