@extends('layouts.admin')

@section('title', 'Edit Parent')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Parent</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.parent.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Parents</a>
            <span class="text-secondary-light">/ Edit Parent</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.parent.update', $parent->id) }}" method="POST" class="mt-24" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Parent Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-12 mb-3">
                            <div class="alert alert-info">
                                <strong>Note:</strong> Updating email or password will change the parent's login credentials.
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="Enter Parent Name" 
                                    value="{{ old('name', $parent->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="email" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Email <span class="text-danger-600">*</span> (for login)
                                </label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                    id="email" name="email" placeholder="Enter Parent Email" 
                                    value="{{ old('email', $parent->email) }}" required>
                                @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">This will be used as login email for parent</small>
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="password" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    New Password (leave blank to keep current)
                                </label>
                                <input type="password" class="form-control @error('password') is-invalid @enderror" 
                                    id="password" name="password" placeholder="Enter New Password (min 6 characters)" 
                                    minlength="6">
                                @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-secondary-light">Only fill this if you want to change the password</small>
                            </div>
                        </div>

                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="phone" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Phone Number
                                </label>
                                <input type="text" class="form-control" 
                                    id="phone" name="phone" 
                                    placeholder="Enter Phone Number" 
                                    value="{{ old('phone', $parent->phone ?? '') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="occupation" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Occupation
                                </label>
                                <input type="text" class="form-control" 
                                    id="occupation" name="occupation" 
                                    placeholder="Enter Occupation" 
                                    value="{{ old('occupation', $parent->occupation ?? '') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="address" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Address
                                </label>
                                <input type="text" class="form-control" 
                                    id="address" name="address" 
                                    placeholder="Enter Address" 
                                    value="{{ old('address', $parent->address ?? '') }}">
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="photo" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Parent Photo
                                </label>
                                <input type="file" class="form-control" 
                                    id="photo" name="photo" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.parent.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Update Parent
                </button>
            </div>
        </div>
    </div>
</form>
@endsection



