@extends('layouts.admin')

@section('title', 'Notifications')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Notifications</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Notifications</span>
        </div>
    </div>
    <a href="{{ route('admin.notifications.create') }}" class="btn btn-primary-600">
        <i class="ri-add-line me-2"></i> Send Notification
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="card shadow-sm radius-12 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24">
        <h6 class="text-lg fw-semibold mb-0">All Notifications</h6>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-borderless table-hover align-middle mb-0">
                <thead class="bg-light-100">
                    <tr>
                        <th class="px-24 py-12">Title</th>
                        <th class="px-24 py-12">Type</th>
                        <th class="px-24 py-12">Target</th>
                        <th class="px-24 py-12">Status</th>
                        <th class="px-24 py-12">Created</th>
                        <th class="px-24 py-12 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($notifications as $notification)
                    <tr>
                        <td class="px-24 py-16">
                            <div class="d-flex align-items-center gap-3">
                                <div class="w-40-px h-40-px bg-{{ $notification->color }}-50 rounded-circle d-flex align-items-center justify-content-center">
                                    @switch($notification->type)
                                        @case('fee')
                                            <i class="ri-money-dollar-circle-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('exam')
                                            <i class="ri-file-text-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('result')
                                            <i class="ri-bar-chart-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('leave')
                                            <i class="ri-calendar-check-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('homework')
                                            <i class="ri-book-2-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('attendance')
                                            <i class="ri-user-follow-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @case('announcement')
                                            <i class="ri-megaphone-line text-{{ $notification->color }}-600 text-xl"></i>
                                            @break
                                        @default
                                            <i class="ri-notification-3-line text-{{ $notification->color }}-600 text-xl"></i>
                                    @endswitch
                                </div>
                                <div>
                                    <h6 class="text-md fw-semibold mb-0">{{ $notification->title }}</h6>
                                    <span class="text-sm text-secondary-light">{{ Str::limit($notification->message, 50) }}</span>
                                </div>
                            </div>
                        </td>
                        <td class="px-24 py-16">
                            <span class="badge bg-{{ $notification->color }}-100 text-{{ $notification->color }}-600 px-12 py-6 radius-4 text-sm fw-medium">
                                {{ ucfirst($notification->type) }}
                            </span>
                        </td>
                        <td class="px-24 py-16">
                            @if($notification->for_all_parents)
                                <span class="badge bg-primary-100 text-primary-600">All Parents</span>
                            @elseif($notification->class_id)
                                <span class="badge bg-info-100 text-info-600">Class: {{ $notification->schoolClass->name ?? 'N/A' }}</span>
                            @elseif($notification->student_id)
                                <span class="badge bg-success-100 text-success-600">Student: {{ $notification->student->name ?? 'N/A' }}</span>
                            @elseif($notification->parent_id)
                                <span class="badge bg-warning-100 text-warning-600">Parent: {{ $notification->parent->name ?? 'N/A' }}</span>
                            @else
                                <span class="badge bg-secondary-100 text-secondary-600">-</span>
                            @endif
                        </td>
                        <td class="px-24 py-16">
                            @if($notification->is_active)
                                <span class="badge bg-success-100 text-success-600 px-12 py-6 radius-4">Active</span>
                            @else
                                <span class="badge bg-danger-100 text-danger-600 px-12 py-6 radius-4">Inactive</span>
                            @endif
                        </td>
                        <td class="px-24 py-16">
                            <span class="text-sm text-secondary-light">{{ $notification->created_at->format('d M Y, h:i A') }}</span>
                        </td>
                        <td class="px-24 py-16 text-center">
                            <div class="d-flex align-items-center justify-content-center gap-2">
                                <a href="{{ route('admin.notifications.edit', $notification->id) }}" 
                                   class="w-32-px h-32-px bg-primary-100 text-primary-600 rounded-circle d-flex justify-content-center align-items-center hover-bg-primary-200">
                                    <i class="ri-pencil-line"></i>
                                </a>
                                <form action="{{ route('admin.notifications.toggle-status', $notification->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" 
                                            class="w-32-px h-32-px bg-{{ $notification->is_active ? 'warning' : 'success' }}-100 text-{{ $notification->is_active ? 'warning' : 'success' }}-600 rounded-circle d-flex justify-content-center align-items-center hover-bg-{{ $notification->is_active ? 'warning' : 'success' }}-200 border-0">
                                        <i class="ri-{{ $notification->is_active ? 'pause' : 'play' }}-line"></i>
                                    </button>
                                </form>
                                <form action="{{ route('admin.notifications.destroy', $notification->id) }}" method="POST" class="d-inline" 
                                      onsubmit="return confirm('Are you sure you want to delete this notification?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="w-32-px h-32-px bg-danger-100 text-danger-600 rounded-circle d-flex justify-content-center align-items-center hover-bg-danger-200 border-0">
                                        <i class="ri-delete-bin-6-line"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-24 py-40 text-center text-secondary-light">
                            <i class="ri-notification-off-line text-4xl mb-12 d-block"></i>
                            No notifications found. <a href="{{ route('admin.notifications.create') }}" class="text-primary-600">Send your first notification</a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    @if($notifications->hasPages())
    <div class="card-footer bg-base border-top py-16 px-24">
        {{ $notifications->links() }}
    </div>
    @endif
</div>
@endsection
