@extends('layouts.admin')

@section('title', 'Leave Requests')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Leave Requests</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Leave Requests</span>
        </div>
    </div>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
        <h6 class="text-lg fw-semibold mb-0">All Requests</h6>
    </div>
    <div class="card-body p-20">
        @if($requests->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Role</th>
                            <th>Student</th>
                            <th>Type</th>
                            <th>Date Range</th>
                            <th>Status</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($requests as $req)
                        <tr>
                            <td>{{ $req->user->name ?? '-' }}</td>
                            <td class="text-capitalize">{{ $req->role }}</td>
                            <td>{{ $req->student->name ?? '-' }}</td>
                            <td>{{ $req->leaveType->name ?? '-' }}</td>
                            <td>{{ $req->from_date->format('d M Y') }} - {{ $req->to_date->format('d M Y') }}</td>
                            <td>
                                @php
                                    $status = $req->status;
                                    $badge = 'bg-secondary-subtle text-secondary';
                                    if($status === 'approved') $badge = 'bg-success-subtle text-success';
                                    elseif($status === 'rejected') $badge = 'bg-danger-subtle text-danger';
                                    elseif($status === 'pending') $badge = 'bg-warning-subtle text-warning';
                                @endphp
                                <span class="badge {{ $badge }}">{{ ucfirst($status) }}</span>
                            </td>
                            <td class="text-end">
                                <a href="{{ route('admin.leave-requests.edit', $req->id) }}" class="btn btn-sm btn-outline-primary">Review</a>
                                <form action="{{ route('admin.leave-requests.destroy', $req->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this request?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-12">
                {{ $requests->links() }}
            </div>
        @else
            <p class="mb-0 text-secondary-light">No leave requests yet.</p>
        @endif
    </div>
</div>
@endsection


