@extends('layouts.admin')

@section('title', 'Homework Details')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Homework Details</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.homework.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Homework</a>
            <span class="text-secondary-light">/ Details</span>
        </div>
    </div>
    <div class="d-flex gap-2">
        <a href="{{ route('admin.homework.edit', $homework->id) }}" class="btn btn-outline-primary">Edit</a>
        <a href="{{ route('admin.homework.index') }}" class="btn btn-outline-secondary">Back</a>
    </div>
</div>

<div class="row gy-3">
    <div class="col-lg-8">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">{{ $homework->title }}</h6>
            </div>
            <div class="card-body p-20">
                <div class="mb-16">
                    <h6 class="fw-semibold mb-8 text-primary-light">Description</h6>
                    <p class="text-secondary-light">{{ $homework->description ?? 'No description provided.' }}</p>
                </div>
                
                @if($homework->notes)
                <div class="mb-16">
                    <h6 class="fw-semibold mb-8 text-primary-light">Notes</h6>
                    <p class="text-secondary-light">{{ $homework->notes }}</p>
                </div>
                @endif

                @if($homework->attachments && count($homework->attachments) > 0)
                <div>
                    <h6 class="fw-semibold mb-8 text-primary-light">Attachments</h6>
                    <div class="d-flex flex-wrap gap-2">
                        @foreach($homework->attachments as $attachment)
                        <a href="{{ asset('storage/'.$attachment) }}" target="_blank" class="badge bg-primary-subtle text-primary p-2 text-decoration-none">
                            <i class="ri-file-line"></i> {{ basename($attachment) }}
                        </a>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">Details</h6>
            </div>
            <div class="card-body p-20">
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Teacher</p>
                    <p class="fw-semibold mb-0">{{ $homework->teacher->name ?? '-' }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Class / Section</p>
                    <p class="fw-semibold mb-0">
                        {{ $homework->schoolClass->name ?? '-' }}
                        @if($homework->section)
                            / {{ $homework->section->name }}
                        @endif
                    </p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Subject</p>
                    <p class="fw-semibold mb-0">{{ $homework->subject->name ?? '-' }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Assigned Date</p>
                    <p class="fw-semibold mb-0">{{ $homework->assigned_date->format('d M Y') }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Due Date</p>
                    <p class="fw-semibold mb-0">{{ $homework->due_date->format('d M Y') }}</p>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Status</p>
                    @php
                        $statusClass = 'bg-secondary-subtle text-secondary';
                        if($homework->status === 'active') $statusClass = 'bg-success-subtle text-success';
                        elseif($homework->status === 'completed') $statusClass = 'bg-primary-subtle text-primary';
                        elseif($homework->status === 'cancelled') $statusClass = 'bg-danger-subtle text-danger';
                    @endphp
                    <span class="badge {{ $statusClass }}">{{ ucfirst($homework->status) }}</span>
                </div>
                <div class="mb-12">
                    <p class="text-sm text-secondary-light mb-1">Published</p>
                    <span class="badge {{ $homework->is_published ? 'bg-success-subtle text-success' : 'bg-secondary-subtle text-secondary' }}">
                        {{ $homework->is_published ? 'Yes' : 'No' }}
                    </span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Submissions Section -->
@if($homework->submissions->count() > 0)
<div class="row gy-3 mt-3">
    <div class="col-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">Student Submissions ({{ $homework->submissions->count() }})</h6>
            </div>
            <div class="card-body p-20">
                <div class="table-responsive">
                    <table class="table align-middle">
                        <thead>
                            <tr>
                                <th>Student</th>
                                <th>Submitted Date</th>
                                <th>Status</th>
                                <th>Notes</th>
                                <th>Attachments</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($homework->submissions as $submission)
                            <tr>
                                <td class="fw-semibold">{{ $submission->student->name ?? '-' }}</td>
                                <td>{{ $submission->submitted_date->format('d M Y') }}</td>
                                <td>
                                    @if($submission->status === 'late')
                                        <span class="badge bg-danger-subtle text-danger">Late Submit</span>
                                    @else
                                        <span class="badge bg-success-subtle text-success">Submitted</span>
                                    @endif
                                </td>
                                <td>{{ $submission->submission_notes ?? '-' }}</td>
                                <td>
                                    @if($submission->attachments && count($submission->attachments) > 0)
                                        <div class="d-flex flex-wrap gap-1">
                                            @foreach($submission->attachments as $attachment)
                                            <a href="{{ asset('storage/'.$attachment) }}" target="_blank" class="badge bg-primary-subtle text-primary p-1 text-decoration-none" style="font-size: 0.7rem;">
                                                <i class="ri-file-line"></i>
                                            </a>
                                            @endforeach
                                        </div>
                                    @else
                                        -
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
@endsection
