@extends('layouts.admin')

@section('title', 'Add Homework')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Add Homework</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.homework.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Homework</a>
            <span class="text-secondary-light">/ Add</span>
        </div>
    </div>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('admin.homework.store') }}" method="POST" enctype="multipart/form-data" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Homework Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Teacher <span class="text-danger-600">*</span>
                            </label>
                            <select name="teacher_id" class="form-control form-select" required>
                                <option value="">Select Teacher</option>
                                @foreach($teachers as $teacher)
                                <option value="{{ $teacher->id }}" {{ old('teacher_id') == $teacher->id ? 'selected' : '' }}>
                                    {{ $teacher->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Class <span class="text-danger-600">*</span>
                            </label>
                            <select name="class_id" id="class_id" class="form-control form-select" required>
                                <option value="">Select Class</option>
                                @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ old('class_id') == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Section
                            </label>
                            <select name="section_id" id="section_id" class="form-control form-select">
                                <option value="">Select Section</option>
                                @foreach($sections as $section)
                                <option value="{{ $section->id }}" {{ old('section_id') == $section->id ? 'selected' : '' }}>
                                    {{ $section->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Subject
                            </label>
                            <select name="subject_id" class="form-control form-select">
                                <option value="">Select Subject</option>
                                @foreach($subjects as $subject)
                                <option value="{{ $subject->id }}" {{ old('subject_id') == $subject->id ? 'selected' : '' }}>
                                    {{ $subject->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Title <span class="text-danger-600">*</span>
                            </label>
                            <input type="text" name="title" class="form-control" required value="{{ old('title') }}" placeholder="Enter homework title">
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Assigned Date <span class="text-danger-600">*</span>
                            </label>
                            <input type="date" name="assigned_date" class="form-control" required value="{{ old('assigned_date', now()->toDateString()) }}">
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Due Date <span class="text-danger-600">*</span>
                            </label>
                            <input type="date" name="due_date" class="form-control" required value="{{ old('due_date') }}">
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Status
                            </label>
                            <select name="status" class="form-control form-select">
                                <option value="active" {{ old('status', 'active') == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Published
                            </label>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="is_published" value="1" id="is_published" {{ old('is_published', true) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_published">
                                    Publish to parents
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Description
                            </label>
                            <textarea name="description" rows="5" class="form-control" placeholder="Enter homework description">{{ old('description') }}</textarea>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Attachments
                            </label>
                            <input type="file" name="attachments[]" class="form-control" multiple accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                            <small class="text-secondary-light">You can select multiple files (PDF, DOC, DOCX, JPG, PNG). Max 10MB per file.</small>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Notes
                            </label>
                            <textarea name="notes" rows="3" class="form-control" placeholder="Additional notes (optional)">{{ old('notes') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.homework.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Homework
                </button>
            </div>
        </div>
    </div>
</form>
@endsection
