@extends('layouts.admin')

@section('title', 'Fees Discount')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Fees Discount</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Fees Discount</span>
        </div>
    </div>
    <a href="{{ route('admin.fees-discount.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Add Fees Discount
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="card h-100">
        <div class="card-body p-0 dataTable-wrapper">
            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='20'>
                    <thead>
                        <tr>
                            <th scope="col">S.L</th>
                            <th scope="col">Name</th>
                            <th scope="col">Type</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Status</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($discounts as $index => $discount)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $discount->name }}</td>
                            <td>{{ ucfirst($discount->type) }}</td>
                            <td>{{ number_format($discount->amount, 2) }}</td>
                            <td>
                                @if($discount->is_active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td class="d-flex flex-wrap gap-2">
                                <a href="{{ route('admin.fees-discount.edit', $discount->id) }}" class="btn btn-sm btn-primary-600">
                                    Edit
                                </a>
                                <form action="{{ route('admin.fees-discount.destroy', $discount->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                        class="btn btn-sm btn-danger-600"
                                        onclick="return confirm('Are you sure you want to delete this fees discount?');">
                                        Delete
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center">No fees discounts found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection



