<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt #{{ $payment->id }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; padding: 20px; background: #f5f5f5; }
        .receipt { max-width: 400px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; border-bottom: 2px dashed #ddd; padding-bottom: 20px; margin-bottom: 20px; }
        .header h1 { font-size: 24px; color: #333; margin-bottom: 5px; }
        .header p { color: #666; font-size: 12px; }
        .receipt-no { background: #f0f0f0; padding: 10px; text-align: center; border-radius: 5px; margin-bottom: 20px; }
        .receipt-no span { font-weight: bold; color: #333; }
        .details { margin-bottom: 20px; }
        .details table { width: 100%; }
        .details td { padding: 8px 0; vertical-align: top; }
        .details td:first-child { color: #666; width: 40%; }
        .details td:last-child { font-weight: 500; text-align: right; }
        .amount-box { background: linear-gradient(135deg, #28a745, #20c997); color: white; padding: 20px; border-radius: 10px; text-align: center; margin: 20px 0; }
        .amount-box .label { font-size: 12px; opacity: 0.9; }
        .amount-box .value { font-size: 32px; font-weight: bold; margin-top: 5px; }
        .footer { text-align: center; border-top: 2px dashed #ddd; padding-top: 20px; margin-top: 20px; }
        .footer p { color: #666; font-size: 11px; margin-bottom: 5px; }
        .status { display: inline-block; padding: 5px 15px; border-radius: 20px; font-size: 12px; font-weight: bold; }
        .status.paid { background: #d4edda; color: #155724; }
        @media print {
            body { padding: 0; background: white; }
            .receipt { box-shadow: none; max-width: 100%; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 30px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px;">
            Print Receipt
        </button>
    </div>
    
    <div class="receipt">
        <div class="header">
            <h1>{{ \App\Models\Setting::first()->site_name ?? 'Tuition Center' }}</h1>
            <p>Payment Receipt</p>
        </div>
        
        <div class="receipt-no">
            Receipt No: <span>#PAY-{{ str_pad($payment->id, 6, '0', STR_PAD_LEFT) }}</span>
        </div>
        
        <div class="details">
            <table>
                <tr>
                    <td>Student Name</td>
                    <td>{{ $collection->student->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Admission No</td>
                    <td>{{ $collection->student->admission_no ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Class</td>
                    <td>{{ $collection->student->schoolClass->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Fee Type</td>
                    <td>{{ $collection->feesType->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                    <td>Payment Date</td>
                    <td>{{ $payment->payment_date->format('d M Y') }}</td>
                </tr>
                <tr>
                    <td>Payment Method</td>
                    <td>{{ $payment->payment_method ?? 'Cash' }}</td>
                </tr>
                @if($payment->reference)
                <tr>
                    <td>Reference</td>
                    <td>{{ $payment->reference }}</td>
                </tr>
                @endif
            </table>
        </div>
        
        <div class="amount-box">
            <div class="label">Amount Paid</div>
            <div class="value">₹{{ number_format($payment->amount, 2) }}</div>
        </div>
        
        <div class="details">
            <table>
                <tr>
                    <td>Total Fee Amount</td>
                    <td>₹{{ number_format($collection->amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Total Paid</td>
                    <td>₹{{ number_format($collection->paid_amount, 2) }}</td>
                </tr>
                <tr>
                    <td>Balance Due</td>
                    <td style="color: {{ $collection->due_amount > 0 ? '#dc3545' : '#28a745' }}; font-weight: bold;">
                        ₹{{ number_format(max(0, $collection->due_amount), 2) }}
                    </td>
                </tr>
            </table>
        </div>
        
        <div class="footer">
            <p>Received by: {{ $payment->receivedBy->name ?? 'Admin' }}</p>
            <p>Printed on: {{ now()->format('d M Y, h:i A') }}</p>
            <p style="margin-top: 10px;">Thank you for your payment!</p>
        </div>
    </div>
</body>
</html>
