<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Payment Receipt - {{ $collection->student->name ?? 'Student' }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; border-bottom: 3px solid #28a745; padding-bottom: 20px; margin-bottom: 30px; }
        .header h1 { font-size: 28px; color: #333; margin-bottom: 5px; }
        .header h2 { font-size: 18px; color: #28a745; font-weight: bold; }
        .paid-stamp { position: absolute; top: 100px; right: 50px; transform: rotate(-15deg); padding: 10px 30px; border: 4px solid #28a745; color: #28a745; font-size: 28px; font-weight: bold; opacity: 0.3; border-radius: 10px; }
        .student-info { background: #f8f9fa; padding: 25px; border-radius: 8px; margin-bottom: 30px; }
        .student-info h3 { margin-bottom: 15px; color: #333; border-bottom: 1px solid #ddd; padding-bottom: 10px; }
        .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .info-item { }
        .info-item label { display: block; font-size: 12px; color: #666; margin-bottom: 3px; }
        .info-item span { font-size: 15px; font-weight: 600; color: #333; }
        .fee-summary { background: linear-gradient(135deg, #28a745, #20c997); color: white; padding: 30px; border-radius: 10px; margin-bottom: 30px; }
        .fee-summary h3 { margin-bottom: 20px; text-align: center; font-size: 18px; }
        .fee-row { display: flex; justify-content: space-between; padding: 10px 0; border-bottom: 1px solid rgba(255,255,255,0.2); }
        .fee-row:last-child { border-bottom: none; font-size: 20px; margin-top: 10px; padding-top: 15px; border-top: 2px solid rgba(255,255,255,0.3); }
        .payment-table { margin-bottom: 30px; }
        .payment-table h3 { margin-bottom: 15px; color: #333; }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px 15px; text-align: left; border: 1px solid #ddd; }
        th { background: #f8f9fa; font-weight: 600; color: #333; }
        .amount { font-weight: bold; color: #28a745; }
        tfoot td { font-weight: bold; background: #e8f5e9; }
        .badge { display: inline-block; padding: 4px 10px; border-radius: 4px; font-size: 11px; background: #e3f2fd; color: #1976d2; }
        .certificate { text-align: center; padding: 30px; background: #fff8e1; border-radius: 10px; border: 2px dashed #ffc107; margin-bottom: 30px; }
        .certificate h4 { color: #f57c00; margin-bottom: 10px; }
        .certificate p { color: #666; font-size: 14px; }
        .footer { display: flex; justify-content: space-between; align-items: flex-end; border-top: 2px solid #ddd; padding-top: 30px; margin-top: 30px; }
        .signature { text-align: center; }
        .signature .line { width: 150px; border-top: 1px solid #333; margin: 40px auto 5px; }
        .signature p { font-size: 12px; color: #666; }
        .qr-placeholder { text-align: center; }
        .qr-placeholder .box { width: 80px; height: 80px; border: 2px solid #ddd; margin: 0 auto 5px; display: flex; align-items: center; justify-content: center; color: #999; font-size: 10px; }
        @media print {
            body { padding: 0; background: white; }
            .container { box-shadow: none; padding: 20px; }
            .no-print { display: none; }
            .paid-stamp { opacity: 0.2; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 30px; background: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px;">
            Print Complete Receipt
        </button>
    </div>
    
    <div class="container" style="position: relative;">
        <div class="paid-stamp">PAID IN FULL</div>
        
        <div class="header">
            <h1>{{ \App\Models\Setting::first()->site_name ?? 'Tuition Center' }}</h1>
            <h2>✓ PAYMENT COMPLETE CERTIFICATE</h2>
        </div>
        
        <div class="student-info">
            <h3>Student Information</h3>
            <div class="info-grid">
                <div class="info-item">
                    <label>Student Name</label>
                    <span>{{ $collection->student->name ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <label>Admission Number</label>
                    <span>{{ $collection->student->admission_no ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <label>Class</label>
                    <span>{{ $collection->student->schoolClass->name ?? 'N/A' }}</span>
                </div>
                <div class="info-item">
                    <label>Invoice Number</label>
                    <span>#FEE-{{ str_pad($collection->id, 6, '0', STR_PAD_LEFT) }}</span>
                </div>
            </div>
        </div>
        
        <div class="fee-summary">
            <h3>Fee Summary</h3>
            <div class="fee-row">
                <span>Fee Type</span>
                <span>{{ $collection->feesType->name ?? 'Tuition Fee' }}</span>
            </div>
            <div class="fee-row">
                <span>Total Amount</span>
                <span>₹{{ number_format($collection->amount, 2) }}</span>
            </div>
            @if($collection->discount_amount > 0)
            <div class="fee-row">
                <span>Discount ({{ $collection->feesDiscount->name ?? 'Applied' }})</span>
                <span>- ₹{{ number_format($collection->discount_amount, 2) }}</span>
            </div>
            @endif
            <div class="fee-row">
                <span><strong>Net Amount Paid</strong></span>
                <span><strong>₹{{ number_format($collection->paid_amount, 2) }}</strong></span>
            </div>
        </div>
        
        <div class="payment-table">
            <h3>Payment History</h3>
            <table>
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Payment Date</th>
                        <th>Amount</th>
                        <th>Method</th>
                        <th>Reference</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($collection->payments->sortBy('payment_date') as $index => $payment)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $payment->payment_date->format('d M Y') }}</td>
                        <td class="amount">₹{{ number_format($payment->amount, 2) }}</td>
                        <td><span class="badge">{{ $payment->payment_method ?? 'Cash' }}</span></td>
                        <td>{{ $payment->reference ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="2" style="text-align: right;"><strong>Total Paid:</strong></td>
                        <td colspan="3"><strong class="amount">₹{{ number_format($collection->paid_amount, 2) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        
        <div class="certificate">
            <h4>✓ Certificate of Payment Completion</h4>
            <p>This is to certify that <strong>{{ $collection->student->name ?? 'the student' }}</strong> has successfully completed all fee payments for <strong>{{ $collection->feesType->name ?? 'the mentioned fee type' }}</strong>. The total amount of <strong>₹{{ number_format($collection->paid_amount, 2) }}</strong> has been received in full.</p>
        </div>
        
        <div class="footer">
            <div class="signature">
                <div class="line"></div>
                <p>Authorized Signature</p>
            </div>
            <div style="text-align: center;">
                <p style="font-size: 12px; color: #666;">Generated on: {{ now()->format('d M Y, h:i A') }}</p>
                <p style="font-size: 11px; color: #999;">This is a computer generated receipt.</p>
            </div>
            <div class="signature">
                <div class="line"></div>
                <p>Institution Seal</p>
            </div>
        </div>
    </div>
</body>
</html>
