<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment History - {{ $collection->student->name ?? 'Student' }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 20px; margin-bottom: 30px; }
        .header h1 { font-size: 28px; color: #333; margin-bottom: 5px; }
        .header h2 { font-size: 18px; color: #666; font-weight: normal; }
        .student-info { display: flex; justify-content: space-between; background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 30px; }
        .student-info .left, .student-info .right { }
        .student-info p { margin-bottom: 8px; font-size: 14px; }
        .student-info strong { color: #333; }
        .summary-boxes { display: flex; gap: 20px; margin-bottom: 30px; }
        .summary-box { flex: 1; padding: 20px; border-radius: 8px; text-align: center; }
        .summary-box.total { background: #e3f2fd; }
        .summary-box.paid { background: #e8f5e9; }
        .summary-box.due { background: #ffebee; }
        .summary-box .label { font-size: 12px; color: #666; margin-bottom: 5px; }
        .summary-box .value { font-size: 24px; font-weight: bold; }
        .summary-box.total .value { color: #1976d2; }
        .summary-box.paid .value { color: #388e3c; }
        .summary-box.due .value { color: #d32f2f; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { padding: 12px 15px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #333; color: white; font-weight: 600; }
        tr:hover { background: #f5f5f5; }
        .amount { font-weight: bold; color: #28a745; }
        .badge { display: inline-block; padding: 4px 10px; border-radius: 4px; font-size: 11px; }
        .badge-info { background: #e3f2fd; color: #1976d2; }
        tfoot td { font-weight: bold; background: #f8f9fa; }
        .footer { text-align: center; border-top: 1px solid #ddd; padding-top: 20px; }
        .footer p { color: #666; font-size: 12px; margin-bottom: 5px; }
        @media print {
            body { padding: 0; background: white; }
            .container { box-shadow: none; padding: 20px; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 30px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px;">
            Print Payment History
        </button>
    </div>
    
    <div class="container">
        <div class="header">
            <h1>{{ \App\Models\Setting::first()->site_name ?? 'Tuition Center' }}</h1>
            <h2>Payment History Report</h2>
        </div>
        
        <div class="student-info">
            <div class="left">
                <p><strong>Student:</strong> {{ $collection->student->name ?? 'N/A' }}</p>
                <p><strong>Admission No:</strong> {{ $collection->student->admission_no ?? 'N/A' }}</p>
                <p><strong>Class:</strong> {{ $collection->student->schoolClass->name ?? 'N/A' }}</p>
            </div>
            <div class="right">
                <p><strong>Fee Type:</strong> {{ $collection->feesType->name ?? 'N/A' }}</p>
                <p><strong>Invoice No:</strong> #FEE-{{ str_pad($collection->id, 6, '0', STR_PAD_LEFT) }}</p>
                <p><strong>Status:</strong> 
                    @if($collection->status == 'paid')
                        <span style="color: #28a745; font-weight: bold;">PAID</span>
                    @elseif($collection->status == 'partial')
                        <span style="color: #ffc107; font-weight: bold;">PARTIAL</span>
                    @else
                        <span style="color: #dc3545; font-weight: bold;">PENDING</span>
                    @endif
                </p>
            </div>
        </div>
        
        <div class="summary-boxes">
            <div class="summary-box total">
                <div class="label">Total Fee</div>
                <div class="value">₹{{ number_format($collection->amount, 2) }}</div>
            </div>
            <div class="summary-box paid">
                <div class="label">Total Paid</div>
                <div class="value">₹{{ number_format($collection->paid_amount, 2) }}</div>
            </div>
            <div class="summary-box due">
                <div class="label">Balance Due</div>
                <div class="value">₹{{ number_format(max(0, $collection->due_amount), 2) }}</div>
            </div>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Method</th>
                    <th>Reference</th>
                    <th>Received By</th>
                </tr>
            </thead>
            <tbody>
                @foreach($collection->payments->sortBy('payment_date') as $index => $payment)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $payment->payment_date->format('d M Y') }}</td>
                    <td class="amount">₹{{ number_format($payment->amount, 2) }}</td>
                    <td>
                        @if($payment->payment_method)
                            <span class="badge badge-info">{{ $payment->payment_method }}</span>
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $payment->reference ?? '-' }}</td>
                    <td>{{ $payment->receivedBy->name ?? 'Admin' }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2" style="text-align: right;">Total Paid:</td>
                    <td class="amount">₹{{ number_format($collection->paid_amount, 2) }}</td>
                    <td colspan="3"></td>
                </tr>
            </tfoot>
        </table>
        
        <div class="footer">
            <p>Generated on: {{ now()->format('d M Y, h:i A') }}</p>
            <p>This is a computer generated document.</p>
        </div>
    </div>
</body>
</html>
