@extends('layouts.admin')

@section('title', 'Edit Fees Collect')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Fees Collect</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.fees-collection.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Fees Collect</a>
            <span class="text-secondary-light">/ Edit</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.fees-collection.update', $collection->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Fees Collection Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Student
                            </label>
                            <select name="student_id" class="form-control form-select">
                                <option value="">Select Student</option>
                                @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ old('student_id', $collection->student_id) == $student->id ? 'selected' : '' }}>
                                    {{ $student->name }} ({{ $student->admission_no ?? '-' }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Class
                            </label>
                            <select name="class_id" class="form-control form-select">
                                <option value="">Select Class</option>
                                @foreach($classes as $class)
                                <option value="{{ $class->id }}" {{ old('class_id', $collection->class_id) == $class->id ? 'selected' : '' }}>
                                    {{ $class->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Section
                            </label>
                            <select name="section_id" class="form-control form-select">
                                <option value="">Select Section</option>
                                @foreach($sections as $section)
                                <option value="{{ $section->id }}" {{ old('section_id', $collection->section_id) == $section->id ? 'selected' : '' }}>
                                    {{ $section->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Fees Type <span class="text-danger-600">*</span>
                            </label>
                            <select name="fees_type_id" class="form-control form-select" id="fees_type_id" required>
                                <option value="">Select Fees Type</option>
                                @foreach($feesTypes as $type)
                                <option value="{{ $type->id }}" data-amount="{{ $type->amount }}" {{ old('fees_type_id', $collection->fees_type_id) == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }} ({{ number_format($type->amount, 2) }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Fees Discount
                            </label>
                            <select name="fees_discount_id" class="form-control form-select">
                                <option value="">Select Discount</option>
                                @foreach($feesDiscounts as $discount)
                                <option value="{{ $discount->id }}" {{ old('fees_discount_id', $collection->fees_discount_id) == $discount->id ? 'selected' : '' }}>
                                    {{ $discount->name }} ({{ ucfirst($discount->type) }} {{ number_format($discount->amount, 2) }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Total Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="amount" id="amount" class="form-control" value="{{ old('amount', $collection->amount) }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Discount Amount
                            </label>
                            <input type="number" step="0.01" name="discount_amount" class="form-control" value="{{ old('discount_amount', $collection->discount_amount) }}">
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Paid Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="paid_amount" class="form-control" value="{{ old('paid_amount', $collection->paid_amount) }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Date <span class="text-danger-600">*</span>
                            </label>
                            <input type="date" name="payment_date" class="form-control" value="{{ old('payment_date', \Carbon\Carbon::parse($collection->payment_date)->toDateString()) }}" required>
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Method
                            </label>
                            <input type="text" name="payment_method" class="form-control" value="{{ old('payment_method', $collection->payment_method) }}" placeholder="Cash / Card / UPI etc">
                        </div>
                        <div class="col-xxl-3 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Reference
                            </label>
                            <input type="text" name="reference" class="form-control" value="{{ old('reference', $collection->reference) }}" placeholder="Transaction reference">
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Notes
                            </label>
                            <textarea name="notes" rows="3" class="form-control" placeholder="Optional notes">{{ old('notes', $collection->notes) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.fees-collection.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Update
                </button>
            </div>
        </div>
    </div>
</form>

<!-- Payment Summary Section -->
<div class="row gy-3 mt-24">
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">
                    <i class="ri-money-dollar-circle-line me-2 text-success-600"></i>
                    Payment Summary
                </h6>
                @if($collection->status == 'paid')
                    <span class="badge bg-success-100 text-success-600 px-16 py-8 radius-8">PAID</span>
                @elseif($collection->status == 'partial')
                    <span class="badge bg-warning-100 text-warning-600 px-16 py-8 radius-8">PARTIAL</span>
                @else
                    <span class="badge bg-danger-100 text-danger-600 px-16 py-8 radius-8">PENDING</span>
                @endif
            </div>
            <div class="card-body p-20">
                <div class="row gy-4">
                    <!-- Student Info -->
                    <div class="col-md-4">
                        <div class="p-16 bg-primary-50 radius-8">
                            <div class="d-flex align-items-center gap-3 mb-12">
                                @if($collection->student && $collection->student->photo)
                                    <img src="{{ asset('storage/' . $collection->student->photo) }}" 
                                         alt="{{ $collection->student->name }}" 
                                         class="w-48-px h-48-px rounded-circle object-fit-cover">
                                @else
                                    <div class="w-48-px h-48-px rounded-circle bg-primary-600 d-flex align-items-center justify-content-center">
                                        <span class="text-white fw-semibold">{{ substr($collection->student->name ?? 'S', 0, 1) }}</span>
                                    </div>
                                @endif
                                <div>
                                    <h6 class="mb-0 text-primary-600">{{ $collection->student->name ?? 'N/A' }}</h6>
                                    <small class="text-secondary-light">{{ $collection->student->admission_no ?? '' }}</small>
                                </div>
                            </div>
                            <div class="text-sm">
                                <p class="mb-4"><strong>Class:</strong> {{ $collection->student->schoolClass->name ?? 'N/A' }}</p>
                                <p class="mb-0"><strong>Fee Type:</strong> {{ $collection->feesType->name ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Amount Details -->
                    <div class="col-md-8">
                        <div class="row gy-3">
                            <div class="col-sm-4">
                                <div class="p-16 bg-info-50 radius-8 text-center">
                                    <p class="text-sm text-secondary-light mb-4">Total Amount</p>
                                    <h4 class="mb-0 text-info-600">₹{{ number_format($collection->amount, 2) }}</h4>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="p-16 bg-success-50 radius-8 text-center">
                                    <p class="text-sm text-secondary-light mb-4">Total Paid</p>
                                    <h4 class="mb-0 text-success-600">₹{{ number_format($collection->paid_amount, 2) }}</h4>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="p-16 {{ $collection->due_amount > 0 ? 'bg-danger-50' : 'bg-success-50' }} radius-8 text-center">
                                    <p class="text-sm text-secondary-light mb-4">Balance Due</p>
                                    <h4 class="mb-0 {{ $collection->due_amount > 0 ? 'text-danger-600' : 'text-success-600' }}">
                                        ₹{{ number_format(max(0, $collection->due_amount), 2) }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                        
                        @if($collection->discount_amount > 0)
                        <div class="mt-12 p-12 bg-warning-50 radius-8">
                            <p class="mb-0 text-sm">
                                <i class="ri-discount-percent-line me-2 text-warning-600"></i>
                                <strong>Discount Applied:</strong> 
                                ₹{{ number_format($collection->discount_amount, 2) }}
                                @if($collection->feesDiscount)
                                    ({{ $collection->feesDiscount->name }})
                                @endif
                            </p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add New Payment Section -->
@if($collection->due_amount > 0)
<div class="row gy-3 mt-24">
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24">
                <h6 class="text-lg fw-semibold mb-0">
                    <i class="ri-add-circle-line me-2 text-primary-600"></i>
                    Add New Payment
                </h6>
            </div>
            <div class="card-body p-20">
                <form action="{{ route('admin.fees-collection.add-payment', $collection->id) }}" method="POST">
                    @csrf
                    <div class="row gy-3">
                        <div class="col-md-3">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Amount <span class="text-danger-600">*</span>
                            </label>
                            <input type="number" step="0.01" name="amount" class="form-control" 
                                   value="{{ max(0, $collection->due_amount) }}" 
                                   max="{{ max(0, $collection->due_amount) }}" required>
                            <small class="text-secondary-light">Max: ₹{{ number_format(max(0, $collection->due_amount), 2) }}</small>
                        </div>
                        <div class="col-md-3">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Date <span class="text-danger-600">*</span>
                            </label>
                            <input type="date" name="payment_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                        </div>
                        <div class="col-md-2">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Payment Method
                            </label>
                            <select name="payment_method" class="form-control form-select">
                                <option value="">Select</option>
                                <option value="Cash">Cash</option>
                                <option value="Card">Card</option>
                                <option value="UPI">UPI</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cheque">Cheque</option>
                                <option value="Online">Online</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                Reference
                            </label>
                            <input type="text" name="reference" class="form-control" placeholder="Transaction ID">
                        </div>
                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-success-600 w-100 py-11">
                                <i class="ri-add-line me-1"></i> Add Payment
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Payment History Section -->
<div class="row gy-3 mt-24">
    <div class="col-lg-12">
        <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
            <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                <h6 class="text-lg fw-semibold mb-0">
                    <i class="ri-history-line me-2 text-info-600"></i>
                    Payment History
                </h6>
                <span class="badge bg-primary-100 text-primary-600 px-12 py-6 radius-8">
                    {{ $collection->payments->count() }} {{ Str::plural('Payment', $collection->payments->count()) }}
                </span>
            </div>
            <div class="card-body p-0">
                @if($collection->payments->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="bg-neutral-50">
                            <tr>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">#</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">Date</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">Amount</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">Method</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">Reference</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light">Received By</th>
                                <th class="px-20 py-12 text-sm fw-semibold text-primary-light text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $runningTotal = 0; @endphp
                            @foreach($collection->payments->sortBy('payment_date') as $index => $payment)
                            @php $runningTotal += $payment->amount; @endphp
                            <tr>
                                <td class="px-20 py-16">
                                    <span class="badge bg-primary-100 text-primary-600">{{ $index + 1 }}</span>
                                </td>
                                <td class="px-20 py-16">
                                    <div class="d-flex flex-column">
                                        <span class="fw-medium">{{ $payment->payment_date->format('d M Y') }}</span>
                                        <small class="text-secondary-light">{{ $payment->created_at->format('h:i A') }}</small>
                                    </div>
                                </td>
                                <td class="px-20 py-16">
                                    <span class="fw-semibold text-success-600">₹{{ number_format($payment->amount, 2) }}</span>
                                </td>
                                <td class="px-20 py-16">
                                    @if($payment->payment_method)
                                        <span class="badge bg-info-100 text-info-600">{{ $payment->payment_method }}</span>
                                    @else
                                        <span class="text-secondary-light">-</span>
                                    @endif
                                </td>
                                <td class="px-20 py-16">
                                    {{ $payment->reference ?? '-' }}
                                </td>
                                <td class="px-20 py-16">
                                    {{ $payment->receivedBy->name ?? 'System' }}
                                </td>
                                <td class="px-20 py-16 text-center">
                                    <a href="{{ route('admin.fees-collection.print-payment', [$collection->id, $payment->id]) }}" 
                                       class="btn btn-sm btn-outline-primary-600 px-12 py-6 me-1"
                                       target="_blank"
                                       title="Print Receipt">
                                        <i class="ri-printer-line"></i>
                                    </a>
                                    <form action="{{ route('admin.fees-collection.delete-payment', [$collection->id, $payment->id]) }}" 
                                          method="POST" 
                                          class="d-inline"
                                          onsubmit="return confirm('Are you sure you want to delete this payment?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger-600 px-12 py-6">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot class="bg-success-50">
                            <tr>
                                <td colspan="2" class="px-20 py-12 fw-semibold text-end">Total Paid:</td>
                                <td class="px-20 py-12 fw-bold text-success-600">₹{{ number_format($collection->paid_amount, 2) }}</td>
                                <td colspan="4"></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                @else
                <div class="p-40 text-center">
                    <div class="mb-16">
                        <i class="ri-wallet-3-line text-secondary-light" style="font-size: 48px;"></i>
                    </div>
                    <h6 class="text-secondary-light mb-8">No Payments Yet</h6>
                    <p class="text-secondary-light mb-0">Add a payment using the form above to start tracking payment history.</p>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row gy-3 mt-24 mb-24">
    <div class="col-12">
        <div class="d-flex gap-3 justify-content-end">
            @if($collection->payments->count() > 0)
            <a href="{{ route('admin.fees-collection.print-all-payments', $collection->id) }}" 
               class="btn btn-outline-info-600 px-20 py-10 radius-8"
               target="_blank">
                <i class="ri-file-list-3-line me-2"></i>Print All Payments
            </a>
            @endif
            @if($collection->due_amount <= 0 && $collection->payments->count() > 0)
            <a href="{{ route('admin.fees-collection.print-complete', $collection->id) }}" 
               class="btn btn-success-600 px-20 py-10 radius-8"
               target="_blank">
                <i class="ri-checkbox-circle-line me-2"></i>Print Complete Receipt
            </a>
            @endif
            <a href="{{ route('admin.fees-collection.show', $collection->id) }}" 
               class="btn btn-outline-primary-600 px-20 py-10 radius-8"
               target="_blank">
                <i class="ri-printer-line me-2"></i>Print Summary
            </a>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const feesTypeSelect = document.getElementById('fees_type_id');
        const amountInput = document.getElementById('amount');
        if (!feesTypeSelect || !amountInput) return;

        function updateAmount() {
            const opt = feesTypeSelect.selectedOptions[0];
            if (!opt) return;
            const val = opt.getAttribute('data-amount');
            if (val !== null && val !== '') {
                amountInput.value = val;
            }
        }

        feesTypeSelect.addEventListener('change', updateAmount);
    });
</script>
@endsection
