@extends('layouts.admin')

@section('title', 'Assigned Monthly Fees')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Assigned Monthly Fees</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Assigned Fees</span>
        </div>
    </div>
    <a href="{{ route('admin.fees-assignment.create') }}" class="btn btn-primary-600 d-flex align-items-center gap-6">
        <span class="d-flex text-md">
            <i class="ri-add-large-line"></i>
        </span>
        Assign Monthly Fee
    </a>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="card h-100">
    <div class="card-body p-0 dataTable-wrapper">
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
            <form class="d-flex flex-wrap align-items-center gap-16" method="GET" action="{{ route('admin.fees-assignment.index') }}">
                <div class="d-flex align-items-center gap-8">
                    <label class="text-sm fw-semibold text-primary-light mb-0">Class</label>
                    <select name="class_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ $classId == $class->id ? 'selected' : '' }}>
                            {{ $class->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="d-flex align-items-center gap-8">
                    <label class="text-sm fw-semibold text-primary-light mb-0">Section</label>
                    <select name="section_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ $sectionId == $section->id ? 'selected' : '' }}>
                            {{ $section->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <button type="submit" class="btn btn-primary-600">Filter</button>
            </form>
        </div>

        <div class="p-0">
            <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='20'>
                <thead>
                    <tr>
                        <th>S.L</th>
                        <th>Student</th>
                        <th>Fees Type</th>
                        <th>Amount</th>
                        <th>Frequency</th>
                        <th>Start Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($assignments as $idx => $assign)
                    <tr>
                        <td>{{ $idx + 1 }}</td>
                        <td>{{ $assign->student->name ?? '-' }}</td>
                        <td>{{ $assign->feesType->name ?? '-' }}</td>
                        <td>{{ number_format($assign->amount, 2) }}</td>
                        <td>{{ ucfirst($assign->frequency) }}</td>
                        <td>{{ $assign->start_date ? $assign->start_date->format('d M Y') : '-' }}</td>
                        <td>
                            @if($assign->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <form action="{{ route('admin.fees-assignment.destroy', $assign->id) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                    class="btn btn-sm btn-danger-600"
                                    onclick="return confirm('Remove this assigned fee from student?');">
                                    Remove
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center">No assigned fees found.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection



