@extends('layouts.admin')

@section('title', 'Assign Monthly Fees')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Assign Monthly Fees</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.fees-assignment.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Assigned Fees</a>
            <span class="text-secondary-light">/ Assign</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

{{-- Filter form (GET) --}}
<form action="{{ route('admin.fees-assignment.create') }}" method="GET" class="mt-24 mb-3">
    <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
        <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
            <h6 class="text-lg fw-semibold mb-0">Filter Students</h6>
        </div>
        <div class="card-body p-20">
            <div class="row gy-3">
                <div class="col-xxl-3 col-xl-4 col-sm-6">
                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Class</label>
                    <select name="class_id" id="class_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ $classId == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-xxl-3 col-xl-4 col-sm-6">
                    <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Section</label>
                    <select name="section_id" id="section_id" class="form-control form-select">
                        <option value="">All</option>
                        @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ $sectionId == $section->id ? 'selected' : '' }}>{{ $section->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-xxl-3 col-xl-4 col-sm-6 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary-600">
                        Filter
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

{{-- Assignment form (POST) --}}
<form action="{{ route('admin.fees-assignment.store') }}" method="POST" class="mt-8">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Select Fees Type & Students</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3 mb-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Fees Type <span class="text-danger-600">*</span></label>
                            <select name="fees_type_id" id="fees_type_id" class="form-control form-select" required>
                                <option value="">Select Fees Type</option>
                                @foreach($feesTypes as $type)
                                <option value="{{ $type->id }}" data-amount="{{ $type->amount }}" {{ old('fees_type_id') == $type->id ? 'selected' : '' }}>
                                    {{ $type->name }} ({{ number_format($type->amount, 2) }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Monthly Amount</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="form-control" value="{{ old('amount') }}" placeholder="Default from fees type">
                            <small class="text-secondary-light">Leave empty to use amount from Fees Type</small>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Start From (Month)</label>
                            <input type="date" name="start_date" class="form-control" value="{{ old('start_date', now()->startOfMonth()->toDateString()) }}">
                        </div>
                    </div>

                    <div class="mb-2 d-flex justify-content-between align-items-center">
                        <h6 class="text-sm fw-semibold text-primary-light mb-0">Students</h6>
                        <div class="d-flex align-items-center gap-2">
                            <span id="selected_count" class="badge bg-neutral-100 text-primary-light border border-neutral-300">
                                0 selected
                            </span>
                            <button type="button" class="btn btn-sm btn-outline-primary" id="select_all_btn">Select All</button>
                            <button type="button" class="btn btn-sm btn-outline-secondary" id="clear_all_btn">Clear</button>
                        </div>
                    </div>
                    <div class="table-responsive" style="max-height: 400px; overflow-y:auto;">
                        <table class="table table-sm mb-0">
                            <thead>
                                <tr>
                                    <th style="width:40px;"></th>
                                    <th>Student</th>
                                    <th>Class / Section</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($students as $student)
                                <tr class="student-row">
                                    <td>
                                        <input type="checkbox" name="student_ids[]" value="{{ $student->id }}" {{ in_array($student->id, old('student_ids', [])) ? 'checked' : '' }}>
                                    </td>
                                    <td>{{ $student->name }}</td>
                                    <td>
                                        {{ $student->schoolClass->name ?? '-' }}
                                        @if($student->section)/ {{ $student->section->name }}@endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center">No students for selected filters.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.fees-assignment.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Assign Fees
                </button>
            </div>
        </div>
    </div>
</form>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const feesTypeSelect = document.getElementById('fees_type_id');
        const amountInput = document.getElementById('amount');
        if (feesTypeSelect && amountInput) {
            function updateAmount() {
                const opt = feesTypeSelect.selectedOptions[0];
                if (!opt) return;
                const val = opt.getAttribute('data-amount');
                if (val && !amountInput.value) {
                    amountInput.value = val;
                }
            }
            feesTypeSelect.addEventListener('change', updateAmount);
            updateAmount();
        }

        const selectAllBtn = document.getElementById('select_all_btn');
        const clearAllBtn = document.getElementById('clear_all_btn');
        const checkboxes = document.querySelectorAll('input[name="student_ids[]"]');
        const selectedCount = document.getElementById('selected_count');

        function refreshSelected() {
            let count = 0;
            checkboxes.forEach(cb => {
                const row = cb.closest('.student-row');
                if (cb.checked) {
                    count++;
                    if (row) row.classList.add('table-active');
                } else if (row) {
                    row.classList.remove('table-active');
                }
            });
            if (selectedCount) {
                selectedCount.textContent = count + ' selected';
            }
        }

        if (selectAllBtn) {
            selectAllBtn.addEventListener('click', () => {
                checkboxes.forEach(cb => cb.checked = true);
                refreshSelected();
            });
        }
        if (clearAllBtn) {
            clearAllBtn.addEventListener('click', () => {
                checkboxes.forEach(cb => cb.checked = false);
                refreshSelected();
            });
        }
        checkboxes.forEach(cb => cb.addEventListener('change', refreshSelected));
        refreshSelected();
    });
</script>
@endsection


