@extends('layouts.admin')

@section('title', 'Edit Exam Type')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Exam Type</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.exam-types.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Exam Types</a>
            <span class="text-secondary-light">/ Edit</span>
        </div>
    </div>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('admin.exam-types.update', $examType->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Exam Type Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Name <span class="text-danger-600">*</span></label>
                            <input type="text" name="name" class="form-control" required value="{{ old('name', $examType->name) }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Code</label>
                            <input type="text" name="short_code" class="form-control" value="{{ old('short_code', $examType->short_code) }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Max Marks</label>
                            <input type="number" name="max_marks" class="form-control" min="0" value="{{ old('max_marks', $examType->max_marks) }}">
                        </div>
                        <div class="col-md-12">
                            <div class="form-check mt-2">
                                <input class="form-check-input" type="checkbox" value="1" id="is_active" name="is_active" {{ old('is_active', $examType->is_active) ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_active">
                                    Active
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Description</label>
                            <textarea name="description" rows="3" class="form-control" placeholder="Enter description (e.g. Mid Term, Final Exam, Unit Test)">{{ old('description', $examType->description) }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.exam-types.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Update Exam Type
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


