@extends('layouts.admin')

@section('title', 'Exam Results')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Exam Results</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.exam-schedules.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Exam Schedule</a>
            <span class="text-secondary-light">/ Results</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
        <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
            <div>
                <h6 class="text-lg fw-semibold mb-0">
                    {{ $examSchedule->examType->name ?? '' }} - 
                    {{ $examSchedule->schoolClass->name ?? '' }} {{ $examSchedule->section->name ?? '' }} - 
                    {{ $examSchedule->subject->name ?? '' }}
                </h6>
                <div class="text-sm text-secondary-light mt-2">
                    Date: {{ $examSchedule->exam_date->format('d M Y') }} | 
                    Time: {{ \Carbon\Carbon::parse($examSchedule->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($examSchedule->end_time)->format('h:i A') }} | 
                    Room: {{ $examSchedule->room->name ?? $examSchedule->room ?? '-' }} | 
                    Max Marks: {{ $examSchedule->max_marks ?? '-' }}
                </div>
            </div>
            <button type="button" class="btn btn-primary-600" data-bs-toggle="modal" data-bs-target="#examResultModal">
                <i class="ri-eye-line me-2"></i>View Results
            </button>
        </div>
        <div class="card-body p-0 dataTable-wrapper">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-16 px-20 py-12 border-bottom border-neutral-200">
                <div class="d-flex flex-wrap align-items-center gap-16">
                    <div class="dropdown">
                        <button type="button"
                            class="px-12 py-5-px border border-neutral-300 radius-8 d-flex align-items-center gap-20"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <span class="d-flex align-items-center gap-1 text-secondary-light text-sm">
                                <i class="ri-file-upload-line text-md line-height-1"></i>
                                Export
                            </span>
                            <span class="">
                                <i class="ri-arrow-down-s-line"></i>
                            </span>
                        </button>
                        <ul class="dropdown-menu p-12 border bg-base shadow">
                            <li>
                                <button type="button"
                                    class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-10">
                                    <i class="ri-file-3-line"></i>
                                    PDF
                                </button>
                            </li>
                            <li>
                                <button type="button"
                                    class="dropdown-item px-16 py-8 rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-10">
                                    <i class="ri-file-excel-line"></i>
                                    Excel
                                </button>
                            </li>
                        </ul>
                    </div>
                    <form class="navbar-search dt-search m-0">
                        <input type="text" class="dt-input bg-transparent radius-4" aria-controls="dataTable"
                            name="search" placeholder="Search...">
                        <iconify-icon icon="ion:search-outline" class="icon"></iconify-icon>
                    </form>
                </div>
                <div class="d-flex align-items-center gap-8 text-secondary-light">
                    <span class="">Rows per page:</span>
                    <div class="dt-length">
                        <select name="dataTable_length" aria-controls="dataTable"
                            class="dt-input form-control form-select">
                            <option value="5">5</option>
                            <option value="10" selected>10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="p-0">
                <table class="table bordered-table mb-0 data-table" id="dataTable" data-page-length='10'>
                    <thead>
                        <tr>
                            <th scope="col">
                                <div class="form-check style-check d-flex align-items-center">
                                    <input class="form-check-input" type="checkbox" id="selectAll">
                                    <label class="form-check-label">S.L</label>
                                </div>
                            </th>
                            <th scope="col">Admission No</th>
                            <th scope="col">Name</th>
                            <th scope="col">Class</th>
                            <th scope="col">Subject</th>
                            <th scope="col">Exam Type</th>
                            <th scope="col">Marks</th>
                            <th scope="col">Percent (%)</th>
                            <th scope="col">Grade</th>
                            <th scope="col">Result</th>
                            <th scope="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($examSchedule->results as $index => $result)
                            @php
                                $student = $result->student;
                                $marks = $result->marks_obtained ?? 0;
                                $maxMarks = $examSchedule->max_marks ?? 100;
                                $percentage = $maxMarks > 0 ? round(($marks / $maxMarks) * 100, 2) : 0;
                                $passMark = $examSchedule->pass_mark ?? ($maxMarks * 0.4);
                                $isPass = !$result->is_absent && $marks >= $passMark;
                            @endphp
                            <tr>
                                <td>
                                    <div class="form-check style-check d-flex align-items-center">
                                        <input class="form-check-input" type="checkbox" value="{{ $result->id }}">
                                        <label class="form-check-label">{{ $index + 1 }}</label>
                                    </div>
                                </td>
                                <td>
                                    <span class="text-primary-600">{{ $student ? ($student->admission_no ?? '-') : '-' }}</span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($student && $student->photo)
                                            <img src="{{ asset('storage/' . $student->photo) }}" alt="{{ $student->name }}"
                                                class="flex-shrink-0 me-12 radius-8" style="width: 40px; height: 40px; object-fit: cover;">
                                        @elseif($student)
                                            <div class="flex-shrink-0 me-12 radius-8 bg-primary-100 d-flex align-items-center justify-content-center" 
                                                style="width: 40px; height: 40px;">
                                                <span class="text-primary-600 fw-bold">{{ substr($student->name, 0, 1) }}</span>
                                            </div>
                                        @else
                                            <div class="flex-shrink-0 me-12 radius-8 bg-neutral-200 d-flex align-items-center justify-content-center" 
                                                style="width: 40px; height: 40px;">
                                                <i class="ri-user-line text-secondary-light"></i>
                                            </div>
                                        @endif
                                        <div>
                                            <h6 class="text-md mb-0 fw-medium flex-grow-1">{{ $student ? $student->name : '-' }}</h6>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $examSchedule->schoolClass->name ?? '-' }} @if($examSchedule->section) ({{ $examSchedule->section->name }})@endif</td>
                                <td><span class="text-primary-600">{{ $examSchedule->subject->name ?? '-' }}</span></td>
                                <td>{{ $examSchedule->examType->name ?? '-' }}</td>
                                <td>
                                    @if($result->is_absent)
                                        <span class="text-secondary-light">Absent</span>
                                    @else
                                        {{ $marks }} / {{ $maxMarks }}
                                    @endif
                                </td>
                                <td>
                                    @if($result->is_absent)
                                        <span class="text-secondary-light">-</span>
                                    @else
                                        {{ $percentage }}%
                                    @endif
                                </td>
                                <td>
                                    @if($result->is_absent)
                                        <span class="text-secondary-light">-</span>
                                    @else
                                        {{ $result->grade ?? '-' }}
                                    @endif
                                </td>
                                <td>
                                    @if($result->is_absent)
                                        <span class="bg-warning-100 text-warning-600 px-16 py-2 radius-4 fw-medium text-sm">Absent</span>
                                    @elseif($isPass)
                                        <span class="bg-success-100 text-success-600 px-16 py-2 radius-4 fw-medium text-sm">Pass</span>
                                    @else
                                        <span class="bg-danger-100 text-danger-600 px-16 py-2 radius-4 fw-medium text-sm">Fail</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="text-primary-light text-xl"
                                            data-bs-toggle="dropdown" data-bs-display="static"
                                            aria-expanded="false">
                                            <iconify-icon icon="tabler:dots-vertical"></iconify-icon>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-lg-end border p-12">
                                            <li>
                                                @if($student)
                                                    <a href="{{ route('admin.student.show', $student->id) }}"
                                                        class="dropdown-item rounded text-secondary-light bg-hover-neutral-200 text-hover-neutral-900 d-flex align-items-center gap-2 py-6">
                                                        <i class="ri-eye-line"></i>
                                                        View
                                                    </a>
                                                @endif
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="11" class="text-center py-20">
                                    <p class="text-secondary-light mb-0">No results recorded yet.</p>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Exam Results Modal -->
<div class="modal fade" id="examResultModal" tabindex="-1" aria-labelledby="examResultModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="examResultModalLabel">Exam Results</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="printableContent">
                @php
                    $results = $examSchedule->results->map(function($result) use ($examSchedule) {
                        $student = $result->student;
                        $marks = $result->marks_obtained ?? 0;
                        $maxMarks = $examSchedule->max_marks ?? 100;
                        $percentage = $maxMarks > 0 ? round(($marks / $maxMarks) * 100, 2) : 0;
                        return [
                            'result' => $result,
                            'student' => $student,
                            'marks' => $marks,
                            'maxMarks' => $maxMarks,
                            'percentage' => $percentage,
                            'is_absent' => $result->is_absent,
                            'grade' => $result->grade,
                        ];
                    })->sortByDesc(function($item) {
                        return $item['is_absent'] ? -1 : $item['marks'];
                    })->values();
                    
                    $topThree = $results->where('is_absent', false)->take(3);
                @endphp
                
                <div class="print-header mb-24">
                    <div class="text-center mb-20">
                        <h4 class="fw-bold mb-2">{{ $examSchedule->examType->name ?? '' }} - {{ $examSchedule->schoolClass->name ?? '' }} {{ $examSchedule->section->name ?? '' }} - {{ $examSchedule->subject->name ?? '' }}</h4>
                        <p class="text-secondary-light mb-0">
                            Date: {{ $examSchedule->exam_date->format('d M Y') }} | 
                            Time: {{ \Carbon\Carbon::parse($examSchedule->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($examSchedule->end_time)->format('h:i A') }} | 
                            Room: {{ $examSchedule->room->name ?? $examSchedule->room ?? '-' }} | 
                            Max Marks: {{ $examSchedule->max_marks ?? '-' }}
                        </p>
                    </div>
                </div>

                @if($topThree->count() > 0)
                <div class="mb-24">
                    <h6 class="fw-semibold mb-12">Top 3 Students</h6>
                    <div class="row g-3">
                        @foreach($topThree as $index => $item)
                            <div class="col-md-4">
                                <div class="shadow-1 radius-12 bg-base p-16 border border-primary-200">
                                    <div class="d-flex align-items-center gap-12 mb-8">
                                        <div class="w-48-px h-48-px bg-primary-100 rounded-circle d-flex align-items-center justify-content-center">
                                            <span class="text-primary-600 fw-bold text-lg">{{ $index + 1 }}</span>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="fw-semibold mb-1">{{ $item['student'] ? $item['student']->name : '-' }}</h6>
                                            <p class="text-sm text-secondary-light mb-0">
                                                Admission: {{ $item['student'] ? ($item['student']->admission_no ?? '-') : '-' }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center pt-8 border-top">
                                        <span class="text-sm text-secondary-light">Marks:</span>
                                        <span class="fw-bold text-primary-600">{{ $item['marks'] }} / {{ $item['maxMarks'] }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mt-2">
                                        <span class="text-sm text-secondary-light">Percentage:</span>
                                        <span class="fw-semibold">{{ $item['percentage'] }}%</span>
                                    </div>
                                    @if($item['grade'])
                                    <div class="d-flex justify-content-between align-items-center mt-2">
                                        <span class="text-sm text-secondary-light">Grade:</span>
                                        <span class="fw-semibold">{{ $item['grade'] }}</span>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                @endif

                <div class="table-responsive">
                    <table class="table bordered-table mb-0">
                        <thead>
                            <tr>
                                <th>S.L</th>
                                <th>Admission No</th>
                                <th>Name</th>
                                <th>Marks</th>
                                <th>Percent (%)</th>
                                <th>Grade</th>
                                <th>Result</th>
                                <th>Remark</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($results as $index => $item)
                                @php
                                    $passMark = $examSchedule->pass_mark ?? ($item['maxMarks'] * 0.4);
                                    $isPass = !$item['is_absent'] && $item['marks'] >= $passMark;
                                @endphp
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td><span class="text-primary-600">{{ $item['student'] ? ($item['student']->admission_no ?? '-') : '-' }}</span></td>
                                    <td>{{ $item['student'] ? $item['student']->name : '-' }}</td>
                                    <td>
                                        @if($item['is_absent'])
                                            <span class="text-secondary-light">Absent</span>
                                        @else
                                            {{ $item['marks'] }} / {{ $item['maxMarks'] }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($item['is_absent'])
                                            <span class="text-secondary-light">-</span>
                                        @else
                                            {{ $item['percentage'] }}%
                                        @endif
                                    </td>
                                    <td>{{ $item['is_absent'] ? '-' : ($item['grade'] ?? '-') }}</td>
                                    <td>
                                        @if($item['is_absent'])
                                            <span class="badge bg-warning-subtle text-warning">Absent</span>
                                        @elseif($isPass)
                                            <span class="badge bg-success-subtle text-success">Pass</span>
                                        @else
                                            <span class="badge bg-danger-subtle text-danger">Fail</span>
                                        @endif
                                    </td>
                                    <td>{{ $item['result']->remark ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary-600" onclick="printResults()">
                    <i class="ri-printer-line me-2"></i>Print (A4)
                </button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Select all checkbox functionality
        const selectAll = document.getElementById('selectAll');
        if (selectAll) {
            selectAll.addEventListener('change', function() {
                const checkboxes = document.querySelectorAll('tbody input[type="checkbox"]');
                checkboxes.forEach(checkbox => {
                    checkbox.checked = this.checked;
                });
            });
        }

        // DataTable initialization if available
        if (typeof DataTable !== 'undefined') {
            let table = new DataTable('#dataTable', {
                pageLength: 10,
                responsive: true
            });

            // Handle search input
            const searchInput = document.querySelector('.dt-search .dt-input');
            if (searchInput) {
                searchInput.addEventListener('keyup', function() {
                    table.search(this.value).draw();
                });
            }

            // Handle page length change
            const lengthSelect = document.querySelector('.dt-length .dt-input');
            if (lengthSelect) {
                lengthSelect.addEventListener('change', function() {
                    table.page.len(parseInt(this.value)).draw();
                });
            }
        }
    });

    function printResults() {
        const printContent = document.getElementById('printableContent').innerHTML;
        const originalContent = document.body.innerHTML;
        
        // Create print window
        const printWindow = window.open('', '_blank');
        printWindow.document.write(`
            <!DOCTYPE html>
            <html>
            <head>
                <title>Exam Results - Print</title>
                <style>
                    @page {
                        size: A4;
                        margin: 15mm;
                    }
                    body {
                        font-family: Arial, sans-serif;
                        font-size: 12px;
                        line-height: 1.5;
                        color: #000;
                        margin: 0;
                        padding: 20px;
                    }
                    .print-header {
                        margin-bottom: 20px;
                        text-align: center;
                    }
                    .print-header h4 {
                        font-size: 18px;
                        font-weight: bold;
                        margin-bottom: 10px;
                    }
                    .print-header p {
                        font-size: 11px;
                        color: #666;
                    }
                    table {
                        width: 100%;
                        border-collapse: collapse;
                        margin-top: 20px;
                    }
                    table th, table td {
                        border: 1px solid #ddd;
                        padding: 8px;
                        text-align: left;
                    }
                    table th {
                        background-color: #f5f5f5;
                        font-weight: bold;
                    }
                    .row {
                        display: flex;
                        flex-wrap: wrap;
                        margin: -10px;
                    }
                    .col-md-4 {
                        flex: 0 0 33.333%;
                        padding: 10px;
                    }
                    .shadow-1 {
                        border: 1px solid #e0e0e0;
                        border-radius: 8px;
                        padding: 15px;
                        margin-bottom: 15px;
                    }
                    .text-primary-600 {
                        color: #2563eb;
                    }
                    .text-secondary-light {
                        color: #666;
                    }
                    .fw-bold {
                        font-weight: bold;
                    }
                    .fw-semibold {
                        font-weight: 600;
                    }
                    .mb-20 {
                        margin-bottom: 20px;
                    }
                    .mb-12 {
                        margin-bottom: 12px;
                    }
                    .mb-8 {
                        margin-bottom: 8px;
                    }
                    .mb-2 {
                        margin-bottom: 2px;
                    }
                    .mb-0 {
                        margin-bottom: 0;
                    }
                    .mt-2 {
                        margin-top: 2px;
                    }
                    .p-16 {
                        padding: 16px;
                    }
                    .gap-12 {
                        gap: 12px;
                    }
                    .d-flex {
                        display: flex;
                    }
                    .align-items-center {
                        align-items: center;
                    }
                    .justify-content-between {
                        justify-content: space-between;
                    }
                    .flex-grow-1 {
                        flex-grow: 1;
                    }
                    .w-48-px {
                        width: 48px;
                    }
                    .h-48-px {
                        height: 48px;
                    }
                    .bg-primary-100 {
                        background-color: #dbeafe;
                    }
                    .rounded-circle {
                        border-radius: 50%;
                    }
                    .border-top {
                        border-top: 1px solid #e0e0e0;
                    }
                    .pt-8 {
                        padding-top: 8px;
                    }
                    .text-sm {
                        font-size: 11px;
                    }
                    .text-lg {
                        font-size: 16px;
                    }
                    .badge {
                        display: inline-block;
                        padding: 4px 8px;
                        border-radius: 4px;
                        font-size: 11px;
                        font-weight: 500;
                    }
                    .bg-success-subtle {
                        background-color: #d1fae5;
                        color: #059669;
                    }
                    .bg-danger-subtle {
                        background-color: #fee2e2;
                        color: #dc2626;
                    }
                    .bg-warning-subtle {
                        background-color: #fef3c7;
                        color: #d97706;
                    }
                    @media print {
                        body {
                            margin: 0;
                            padding: 10px;
                        }
                        .no-print {
                            display: none;
                        }
                    }
                </style>
            </head>
            <body>
                ${printContent}
            </body>
            </html>
        `);
        printWindow.document.close();
        
        // Wait for content to load, then print
        setTimeout(() => {
            printWindow.print();
        }, 250);
    }
</script>
@endsection
