@extends('layouts.admin')

@section('title', 'Exam Schedule')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Exam Schedule</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Examinations / Exam Schedule</span>
        </div>
    </div>
    <a href="{{ route('admin.exam-schedules.create') }}" class="btn btn-primary-600">Add Exam Schedule</a>
</div>

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
    <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
        <h6 class="text-lg fw-semibold mb-0">Schedule List</h6>
        <form class="d-flex flex-wrap align-items-end gap-12" method="GET" action="{{ route('admin.exam-schedules.index') }}">
            <div>
                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Exam</label>
                <select name="exam_type_id" class="form-control form-select">
                    <option value="">All Exams</option>
                    @foreach($examTypes as $type)
                        <option value="{{ $type->id }}" {{ (int)($examTypeId ?? 0) === $type->id ? 'selected' : '' }}>
                            {{ $type->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Class</label>
                <select name="class_id" class="form-control form-select">
                    <option value="">All</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ (int)($classId ?? 0) === $class->id ? 'selected' : '' }}>
                            {{ $class->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Section</label>
                <select name="section_id" class="form-control form-select">
                    <option value="">All</option>
                    @foreach($sections as $section)
                        <option value="{{ $section->id }}" {{ (int)($sectionId ?? 0) === $section->id ? 'selected' : '' }}>
                            {{ $section->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="d-flex gap-8">
                <button type="submit" class="btn btn-primary-600">Filter</button>
                <a href="{{ route('admin.exam-schedules.index') }}" class="btn btn-outline-secondary">Clear</a>
            </div>
        </form>
    </div>
    <div class="card-body p-20">
        @if($schedules->count())
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>Exam</th>
                            <th>Class / Section</th>
                            <th>Subject</th>
                            <th>Date</th>
                            <th>Time</th>
                            <th>Room</th>
                            <th>Max Marks</th>
                            <th>Pass Mark</th>
                            <th>Results</th>
                            <th>Status</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($schedules as $schedule)
                        <tr>
                            <td>{{ $schedule->examType->name ?? '-' }}</td>
                            <td>{{ $schedule->schoolClass->name ?? '-' }} @if($schedule->section)/ {{ $schedule->section->name }}@endif</td>
                            <td>{{ $schedule->subject->name ?? '-' }}</td>
                            <td>{{ $schedule->exam_date->format('d M Y') }}</td>
                            <td>{{ \Carbon\Carbon::parse($schedule->start_time)->format('h:i A') }} - {{ \Carbon\Carbon::parse($schedule->end_time)->format('h:i A') }}</td>
                            <td>{{ $schedule->room ?: '-' }}</td>
                            <td>{{ $schedule->max_marks ?? '-' }}</td>
                            <td>{{ $schedule->pass_mark ?? '-' }}</td>
                            <td>{{ $schedule->results_count ?? 0 }}</td>
                            <td>
                                @if($schedule->is_published)
                                    <span class="badge bg-success-subtle text-success">Published</span>
                                @else
                                    <span class="badge bg-secondary-subtle text-secondary">Draft</span>
                                </td>
                            @endif
                            <td class="text-end">
                                <div class="d-flex flex-wrap justify-content-end gap-2">
                                    <a href="{{ route('admin.exam-schedules.show', $schedule->id) }}" class="btn btn-sm btn-outline-info">
                                        View Results
                                    </a>
                                    <a href="{{ route('admin.exam-schedules.edit', $schedule->id) }}" class="btn btn-sm btn-outline-primary">
                                        Edit
                                    </a>
                                    <form action="{{ route('admin.exam-schedules.destroy', $schedule->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger"
                                                onclick="return confirm('Delete this schedule?')">
                                            Delete
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="mt-12">
                {{ $schedules->links() }}
            </div>
        @else
            <p class="mb-0 text-secondary-light">No exam schedule entries found.</p>
        @endif
    </div>
</div>
@endsection


