@extends('layouts.admin')

@section('title', 'Add Exam Schedule')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Add Exam Schedule</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.exam-schedules.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Exam Schedule</a>
            <span class="text-secondary-light">/ Add</span>
        </div>
    </div>
</div>

@if($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('admin.exam-schedules.store') }}" method="POST" class="mt-24">
    @csrf
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Schedule Details</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Exam <span class="text-danger-600">*</span></label>
                            <select name="exam_type_id" class="form-control form-select" required>
                                <option value="">Select Exam</option>
                                @foreach($examTypes as $type)
                                    <option value="{{ $type->id }}" {{ (int)old('exam_type_id', $examTypeId) === $type->id ? 'selected' : '' }}>
                                        {{ $type->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Class <span class="text-danger-600">*</span></label>
                            <select name="class_id" class="form-control form-select" required>
                                <option value="">Select Class</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->id }}" {{ (int)old('class_id', $classId) === $class->id ? 'selected' : '' }}>
                                        {{ $class->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Section <span class="text-danger-600">*</span></label>
                            <select name="section_id" class="form-control form-select" required>
                                <option value="">Select Section</option>
                                @foreach($sections as $section)
                                    <option value="{{ $section->id }}" {{ (int)old('section_id', $sectionId) === $section->id ? 'selected' : '' }}>
                                        {{ $section->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Subject <span class="text-danger-600">*</span></label>
                            <select name="subject_id" class="form-control form-select" required>
                                <option value="">Select Subject</option>
                                @foreach($subjects as $subject)
                                    <option value="{{ $subject->id }}" {{ (int)old('subject_id') === $subject->id ? 'selected' : '' }}>
                                        {{ $subject->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Exam Date <span class="text-danger-600">*</span></label>
                            <input type="date" name="exam_date" class="form-control" value="{{ old('exam_date') }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Time <span class="text-danger-600">*</span></label>
                            <div class="d-flex gap-8">
                                <input type="time" name="start_time" class="form-control" value="{{ old('start_time') }}" required>
                                <span class="align-self-center text-secondary-light">to</span>
                                <input type="time" name="end_time" class="form-control" value="{{ old('end_time') }}" required>
                            </div>
                            <small class="text-secondary-light d-block mt-1">Use 24-hour format (e.g. 09:30)</small>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Room</label>
                            <select name="room_id" class="form-control form-select">
                                <option value="">Select Room</option>
                                @foreach($rooms as $room)
                                    <option value="{{ $room->id }}" {{ (int)old('room_id') === $room->id ? 'selected' : '' }}>
                                        {{ $room->name }}@if($room->capacity) ({{ $room->capacity }})@endif
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Max Marks</label>
                            <input type="number" name="max_marks" class="form-control" min="0" value="{{ old('max_marks') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Pass Mark</label>
                            <input type="number" name="pass_mark" class="form-control" min="0" value="{{ old('pass_mark') }}">
                            <small class="text-secondary-light d-block mt-1">Used later on result page.</small>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mt-4">
                                <input class="form-check-input" type="checkbox" value="1" id="is_published" name="is_published" {{ old('is_published') ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_published">
                                    Publish for students/parents
                                </label>
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="text-sm fw-semibold text-primary-light d-inline-block mb-8">Note</label>
                            <textarea name="note" rows="3" class="form-control" placeholder="Enter any special instructions (optional)">{{ old('note') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.exam-schedules.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Schedule
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


