@extends('layouts.admin')

@section('title', 'Exam Results')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Exam Results</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <span class="text-secondary-light">/ Examinations / Exam Results</span>
        </div>
    </div>
</div>

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<div class="mt-24">
    <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
        <div class="card-header border-bottom bg-base py-16 px-24">
            <h6 class="text-lg fw-semibold mb-0">Select Class & Division</h6>
        </div>
        <div class="card-body p-20">
            <form class="d-flex flex-wrap align-items-end gap-16 mb-20" method="GET" action="{{ route('admin.exam-results.index') }}">
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Class</label>
                    <select name="class_id" class="form-control form-select" required>
                        <option value="">Select Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}" {{ (int)($classId ?? 0) === $class->id ? 'selected' : '' }}>
                                {{ $class->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="text-sm fw-semibold text-primary-light mb-8">Division</label>
                    <select name="section_id" class="form-control form-select" required>
                        <option value="">Select Division</option>
                        @foreach($sections as $section)
                            <option value="{{ $section->id }}" {{ (int)($sectionId ?? 0) === $section->id ? 'selected' : '' }}>
                                {{ $section->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="d-flex gap-10">
                    <button type="submit" class="btn btn-primary-600">
                        Show Exams
                    </button>
                    <a href="{{ route('admin.exam-results.index') }}" class="btn btn-outline-secondary">
                        Clear
                    </a>
                </div>
            </form>

            @if($classId && $sectionId && $schedules->count() > 0)
                <div class="table-responsive">
                    <table class="table bordered-table mb-0">
                        <thead>
                            <tr>
                                <th>S.L</th>
                                <th>Exam Type</th>
                                <th>Subject</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Max Marks</th>
                                <th>Results Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($schedules as $index => $schedule)
                                @php
                                    $hasResults = $schedule->results && $schedule->results->count() > 0;
                                    $resultsCount = $schedule->results ? $schedule->results->count() : 0;
                                @endphp
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $schedule->examType->name ?? '-' }}</td>
                                    <td>{{ $schedule->subject->name ?? '-' }}</td>
                                    <td>{{ $schedule->exam_date->format('d M Y') }}</td>
                                    <td>
                                        {{ \Carbon\Carbon::parse($schedule->start_time)->format('h:i A') }} - 
                                        {{ \Carbon\Carbon::parse($schedule->end_time)->format('h:i A') }}
                                    </td>
                                    <td>{{ $schedule->max_marks ?? '-' }}</td>
                                    <td>
                                        @if($hasResults)
                                            <span class="badge bg-success-subtle text-success">
                                                Results Available ({{ $resultsCount }})
                                            </span>
                                        @else
                                            <span class="badge bg-warning-subtle text-warning">
                                                Results Not Updated
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($hasResults)
                                            <a href="{{ route('admin.exam-schedules.show', $schedule->id) }}" 
                                                class="btn btn-sm btn-primary-600">
                                                View Results
                                            </a>
                                        @else
                                            <span class="text-secondary-light text-sm">No results yet</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @elseif($classId && $sectionId)
                <div class="alert alert-info">
                    <p class="mb-0">No exam schedules found for the selected class and division.</p>
                </div>
            @else
                <div class="text-center py-20">
                    <p class="text-secondary-light mb-0">Please select class and division to view exam results.</p>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
