@extends('layouts.admin')

@section('title', 'Edit Batch')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Batch</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.batch.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Batch</a>
            <span class="text-secondary-light">/ Edit Batch</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.batch.update', $batch->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Batch Information</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Batch Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="e.g., Morning, Evening, Weekend" 
                                    value="{{ old('name', $batch->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="start_time" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Start Time <span class="text-danger-600">*</span>
                                </label>
                                <input type="time" class="form-control @error('start_time') is-invalid @enderror" 
                                    id="start_time" name="start_time" 
                                    value="{{ old('start_time', \Carbon\Carbon::parse($batch->start_time)->format('H:i')) }}" required>
                                @error('start_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="end_time" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    End Time <span class="text-danger-600">*</span>
                                </label>
                                <input type="time" class="form-control @error('end_time') is-invalid @enderror" 
                                    id="end_time" name="end_time" 
                                    value="{{ old('end_time', \Carbon\Carbon::parse($batch->end_time)->format('H:i')) }}" required>
                                @error('end_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-4 col-xl-4 col-sm-6">
                            <div class="">
                                <label for="is_active" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Status
                                </label>
                                <select id="is_active" name="is_active" class="form-control form-select">
                                    <option value="0" {{ old('is_active', $batch->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                                    <option value="1" {{ old('is_active', $batch->is_active) == '1' ? 'selected' : '' }}>Active</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="">
                                <label for="description" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Description
                                </label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                    id="description" name="description" rows="3" 
                                    placeholder="Enter batch description">{{ old('description', $batch->description) }}</textarea>
                                @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.batch.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


