@extends('layouts.admin')

@section('title', 'Edit Academic Year')

@section('content')
<div class="breadcrumb d-flex flex-wrap align-items-center justify-content-between gap-3 mb-24">
    <div class="">
        <h1 class="fw-semibold mb-4 h6 text-primary-light">Edit Academic Year</h1>
        <div class="">
            <a href="{{ route('admin.dashboard') }}" class="text-secondary-light hover-text-primary hover-underline">Dashboard</a>
            <a href="{{ route('admin.academic-year.index') }}" class="text-secondary-light hover-text-primary hover-underline">/ Academic Year</a>
            <span class="text-secondary-light">/ Edit Academic Year</span>
        </div>
    </div>
</div>

@if(isset($errors) && $errors->any())
<div class="alert alert-danger">
    <ul class="mb-0">
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif

<form action="{{ route('admin.academic-year.update', $academicYear->id) }}" method="POST" class="mt-24">
    @csrf
    @method('PUT')
    <div class="row gy-3">
        <div class="col-lg-12">
            <div class="shadow-1 radius-12 bg-base h-100 overflow-hidden">
                <div class="card-header border-bottom bg-base py-16 px-24 d-flex align-items-center justify-content-between">
                    <h6 class="text-lg fw-semibold mb-0">Academic Year Information</h6>
                </div>
                <div class="card-body p-20">
                    <div class="row gy-3">
                        <div class="col-xxl-6 col-xl-6 col-sm-6">
                            <div class="">
                                <label for="name" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Academic Year Name <span class="text-danger-600">*</span>
                                </label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                    id="name" name="name" placeholder="e.g., Jun 2025/2026" 
                                    value="{{ old('name', $academicYear->name) }}" required>
                                @error('name')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-sm-6">
                            <div class="">
                                <label for="start_date" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Start Date <span class="text-danger-600">*</span>
                                </label>
                                <input type="date" class="form-control @error('start_date') is-invalid @enderror" 
                                    id="start_date" name="start_date" 
                                    value="{{ old('start_date', $academicYear->start_date->format('Y-m-d')) }}" required>
                                @error('start_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-sm-6">
                            <div class="">
                                <label for="end_date" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    End Date <span class="text-danger-600">*</span>
                                </label>
                                <input type="date" class="form-control @error('end_date') is-invalid @enderror" 
                                    id="end_date" name="end_date" 
                                    value="{{ old('end_date', $academicYear->end_date->format('Y-m-d')) }}" required>
                                @error('end_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-sm-6">
                            <div class="">
                                <label for="is_active" class="text-sm fw-semibold text-primary-light d-inline-block mb-8">
                                    Status
                                </label>
                                <select id="is_active" name="is_active" class="form-control form-select">
                                    <option value="0" {{ old('is_active', $academicYear->is_active) == '0' ? 'selected' : '' }}>Inactive</option>
                                    <option value="1" {{ old('is_active', $academicYear->is_active) == '1' ? 'selected' : '' }}>Active</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-center gap-3 mt-8">
                <a href="{{ route('admin.academic-year.index') }}" 
                    class="border border-danger-600 bg-hover-danger-200 text-danger-600 text-md px-50 py-11 radius-8">
                    Cancel
                </a>
                <button type="submit"
                    class="btn btn-primary-600 border border-primary-600 text-md px-28 py-12 radius-8">
                    Save Changes
                </button>
            </div>
        </div>
    </div>
</form>
@endsection


