<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Teacher;
use Illuminate\Support\Facades\Hash;

class TeacherSeeder extends Seeder
{
    public function run(): void
    {
        $email = 'rahul.menon@tuition.com';
        
        // Cleanup if exists
        $existing = User::where('email', $email)->first();
        if ($existing) {
            Teacher::where('user_id', $existing->id)->delete();
            $existing->delete();
        }

        $user = User::create([
            'name' => 'Rahul Menon',
            'email' => $email,
            'password' => Hash::make('password'),
            'role' => 'teacher',
            'phone' => '1234567890'
        ]);

        Teacher::create([
            'user_id' => $user->id,
            'name' => 'Rahul Menon',
            'email' => $email,
            'phone' => '1234567890',
            'teacher_id' => 'TCH-' . $user->id,
            'subject' => 'Mathematics',
            'join_date' => now(),
            'is_active' => true
        ]);
        
        $this->command->info('Teacher user created successfully.');
    }
}
