<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('attendances', function (Blueprint $table) {
            $table->id();
            $table->date('date');
            $table->foreignId('student_id')->constrained('students')->cascadeOnDelete();
            $table->foreignId('class_id')->nullable()->constrained('school_classes')->nullOnDelete();
            $table->foreignId('section_id')->nullable()->constrained('sections')->nullOnDelete();
            $table->foreignId('teacher_id')->nullable()->constrained('teachers')->nullOnDelete();
            $table->enum('status', ['present', 'absent', 'late', 'leave'])->default('present');
            $table->string('remark')->nullable();
            $table->timestamps();

            $table->unique(['date', 'student_id'], 'attendances_date_student_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('attendances');
    }
};



