<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('fees_groups', function (Blueprint $table) {
            $table->foreignId('fees_type_id')->nullable()->after('name')->constrained('fees_types')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('fees_groups', function (Blueprint $table) {
            $table->dropConstrainedForeignId('fees_type_id');
        });
    }
};


