<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            // Medical Details
            $table->string('blood_group')->nullable()->after('country');
            $table->string('height')->nullable()->after('blood_group');
            $table->string('weight')->nullable()->after('height');
            
            // Bank Details
            $table->string('bank_account_number')->nullable()->after('weight');
            $table->string('bank_name')->nullable()->after('bank_account_number');
            $table->string('ifsc_code')->nullable()->after('bank_name');
            $table->string('national_identification_number')->nullable()->after('ifsc_code');
            
            // Previous School Details
            $table->string('previous_school_name')->nullable()->after('national_identification_number');
            $table->text('previous_school_address')->nullable()->after('previous_school_name');
            
            // Hostel Details
            $table->string('hostel')->nullable()->after('previous_school_address');
            $table->string('room_no')->nullable()->after('hostel');
            
            // Address - split into current and permanent
            $table->text('current_address')->nullable()->after('room_no');
            $table->text('permanent_address')->nullable()->after('current_address');
            
            // Student Details (additional notes)
            $table->text('student_details')->nullable()->after('permanent_address');
            
            // Student Login (for creating student user account - we'll store email here, password will be in users table)
            $table->string('student_login_email')->nullable()->after('student_details');
            
            // Guardian additional fields
            $table->string('guardian_email')->nullable()->after('guardian_relation');
            $table->string('guardian_occupation')->nullable()->after('guardian_email');
            $table->text('guardian_address')->nullable()->after('guardian_occupation');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropColumn([
                'blood_group', 'height', 'weight',
                'bank_account_number', 'bank_name', 'ifsc_code', 'national_identification_number',
                'previous_school_name', 'previous_school_address',
                'hostel', 'room_no',
                'current_address', 'permanent_address',
                'student_details', 'student_login_email',
                'guardian_email', 'guardian_occupation', 'guardian_address'
            ]);
        });
    }
};
