<?php

namespace App\Services\PaymentGateway;

use App\Models\FeesCollection;

interface PaymentGatewayInterface
{
    /**
     * Create a payment/order for a given fees collection.
     * Should return data required to redirect or render a payment widget.
     */
    public function createOrder(FeesCollection $collection): array;

    /**
     * Handle gateway callback/webhook to update payment status.
     */
    public function handleCallback(array $payload): void;
}


