<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_name',
        'logo',
        'logo_light',
        'logo_icon',
        'login_image',
        'cashfree_active',
        'cashfree_app_id',
        'cashfree_secret_key',
        'cashfree_mode',
        'razorpay_active',
        'razorpay_key_id',
        'razorpay_key_secret',
        'phonepe_active',
        'phonepe_merchant_id',
        'phonepe_salt_key',
        'phonepe_salt_index',
        'phonepe_mode',
        'contact_phone',
        'contact_email',
        'contact_whatsapp',
        'address',
        'city',
        'state',
        'zip_code',
        'map_url',
        'office_hours',
        'website_url',
        'facebook_url',
        'instagram_url',
        'fcm_server_key',
        'fcm_project_id',
        'push_notifications_enabled',
    ];

    protected $casts = [
        'push_notifications_enabled' => 'boolean',
    ];
}


