<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\Student;

class Section extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'class_id',
        'seats',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }
    
    public function students()
    {
        return $this->hasMany(Student::class, 'section_id');
    }
    
    /**
     * Get the number of filled seats in this section
     */
    public function getFilledSeatsAttribute()
    {
        return $this->students()->where('is_active', true)->count();
    }
    
    /**
     * Get the number of available seats in this section
     */
    public function getAvailableSeatsAttribute()
    {
        return max(0, $this->seats - $this->filled_seats);
    }
    
    /**
     * Check if the section has available seats
     */
    public function hasAvailableSeats(): bool
    {
        return $this->available_seats > 0;
    }
}
