<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeesType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'amount',
        'description',
        'is_active',
        'is_recurring',
        'recurring_frequency',
        'recurring_day',
        'recurring_start_date',
        'recurring_end_date',
        'last_generated_date',
        'auto_generate',
    ];

    protected $casts = [
        'is_recurring' => 'boolean',
        'auto_generate' => 'boolean',
        'recurring_start_date' => 'date',
        'recurring_end_date' => 'date',
        'last_generated_date' => 'date',
    ];

    /**
     * Check if fee should be generated this month
     */
    public function shouldGenerateNow()
    {
        if (!$this->is_recurring || !$this->auto_generate) {
            return false;
        }

        $today = now();
        
        // Check if within date range
        if ($this->recurring_start_date && $today->lt($this->recurring_start_date)) {
            return false;
        }
        if ($this->recurring_end_date && $today->gt($this->recurring_end_date)) {
            return false;
        }

        // Check if already generated this period
        if ($this->last_generated_date) {
            switch ($this->recurring_frequency) {
                case 'monthly':
                    if ($this->last_generated_date->isSameMonth($today)) {
                        return false;
                    }
                    break;
                case 'quarterly':
                    if ($this->last_generated_date->diffInMonths($today) < 3) {
                        return false;
                    }
                    break;
                case 'yearly':
                    if ($this->last_generated_date->isSameYear($today)) {
                        return false;
                    }
                    break;
            }
        }

        // Check if today is the recurring day
        if ($this->recurring_day && $today->day == $this->recurring_day) {
            return true;
        }

        return false;
    }
}


