<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeesCollection extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'class_id',
        'section_id',
        'fees_type_id',
        'fees_group_id',
        'fees_discount_id',
        'amount',
        'discount_amount',
        'paid_amount',
        'payment_date',
        'payment_method',
        'reference',
        'notes',
    ];

    protected $casts = [
        'payment_date' => 'date',
    ];

    public function feesType()
    {
        return $this->belongsTo(FeesType::class);
    }

    public function feesGroup()
    {
        return $this->belongsTo(FeesGroup::class);
    }

    public function feesDiscount()
    {
        return $this->belongsTo(FeesDiscount::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    public function payments()
    {
        return $this->hasMany(FeePayment::class, 'fees_collection_id')->orderBy('payment_date', 'desc');
    }

    /**
     * Get total paid from payment history
     */
    public function getTotalPaidFromHistoryAttribute()
    {
        return $this->payments()->sum('amount');
    }

    /**
     * Get the payment status based on amounts
     */
    public function getStatusAttribute()
    {
        $dueAmount = $this->amount - ($this->paid_amount ?? 0) - ($this->discount_amount ?? 0);
        
        if ($dueAmount <= 0) {
            return 'paid';
        } elseif ($this->paid_amount > 0) {
            return 'partial';
        } else {
            return 'pending';
        }
    }

    /**
     * Get the due amount
     */
    public function getDueAmountAttribute()
    {
        return $this->amount - ($this->paid_amount ?? 0) - ($this->discount_amount ?? 0);
    }
}


