<?php

namespace App\Http\Controllers;

use App\Models\ExamSchedule;
use Illuminate\Support\Facades\Auth;

class ParentExamController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        if (!$user || !$user->isParent()) {
            abort(403, 'Unauthorized access');
        }

        $children = $user->students()->with('schoolClass','section')->get();
        $childIds = $children->pluck('id')->all();

        $examSchedules = ExamSchedule::with(['examType','subject','schoolClass','section','results' => function ($q) use ($childIds) {
            $q->whereIn('student_id', $childIds);
        }])
            ->whereHas('results', function ($q) use ($childIds) {
                $q->whereIn('student_id', $childIds);
            })
            ->orderBy('exam_date', 'desc')
            ->orderBy('start_time', 'desc')
            ->get();

        return view('parent.exams.index', [
            'user' => $user,
            'children' => $children,
            'examSchedules' => $examSchedules,
        ]);
    }
}


