<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Attendance;
use App\Models\SchoolClass;
use App\Models\Section;

class StudentAttendanceController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }

        $classes = SchoolClass::where('is_active', true)->orderBy('name')->get();
        $sections = Section::where('is_active', true)->orderBy('name')->get();

        $date = $request->input('date', now()->toDateString());
        $classId = $request->input('class_id');
        $sectionId = $request->input('section_id');

        $query = Attendance::with(['student.schoolClass', 'student.section', 'teacher'])
            ->whereDate('date', $date);

        if ($classId) {
            $query->where('class_id', $classId);
        }
        if ($sectionId) {
            $query->where('section_id', $sectionId);
        }

        $records = $query->orderBy('student_id')->get();

        return view('admin.attendance.index', compact(
            'user', 'records', 'classes', 'sections', 'date', 'classId', 'sectionId'
        ));
    }
}


